/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.client.screen.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.client.handler.InventoryButtonHandler;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class MiniInventoryButton
extends Button {
    private final Supplier<List<Component>> tooltip;
    private InventoryButtonHandler.ButtonTargetType type = InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY;
    private final int spriteType;
    private final AbstractContainerScreen<?> parent;
    private final int startX;
    private final int startY;
    private BooleanSupplier shiftTexture = BooleanSuppliers.FALSE;

    @Deprecated(forRemoval=true)
    public MiniInventoryButton(AbstractContainerScreen<?> parent, int spriteType, int x, int y, Consumer<List<String>> legacyTooltip, Button.OnPress onPress) {
        this(parent, spriteType, x, y, () -> {
            ArrayList toConsume = new ArrayList();
            legacyTooltip.accept(toConsume);
            return toConsume.stream().map(z -> Component.translatable((String)z)).toList();
        }, onPress);
    }

    public MiniInventoryButton(AbstractContainerScreen<?> parent, int spriteType, int x, int y, Supplier<List<Component>> tooltip, Button.OnPress onPress) {
        super(Button.builder((Component)Component.literal((String)""), (Button.OnPress)onPress).size(10, 10).pos(parent.getGuiLeft() + x, parent.getGuiTop() + y));
        this.parent = parent;
        this.spriteType = spriteType;
        this.tooltip = tooltip;
        this.startX = x;
        this.startY = y;
    }

    public MiniInventoryButton(AbstractContainerScreen<?> parent, int spriteType, int x, int y, Component tooltip, Button.OnPress onPress) {
        this(parent, spriteType, x, y, () -> List.of(tooltip), onPress);
    }

    public MiniInventoryButton(AbstractContainerScreen<?> parent, int spriteType, int x, int y, String tooltipKey, Button.OnPress onPress) {
        this(parent, spriteType, x, y, (Component)Component.translatable((String)tooltipKey), onPress);
    }

    public MiniInventoryButton setType(InventoryButtonHandler.ButtonTargetType type) {
        this.type = type;
        return this;
    }

    public MiniInventoryButton setTextureShift(BooleanSupplier func) {
        this.shiftTexture = func;
        return this;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int targetX = this.startX + this.type.offX.get() + this.parent.getGuiLeft();
        int targetY = this.startY + this.type.offY.get() + this.parent.getGuiTop();
        this.setX(targetX);
        this.setY(targetY);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int u = this.spriteType * this.width;
        int v = 25 + (this.isHovered ? this.height : 0);
        if (this.shiftTexture.getAsBoolean()) {
            v += this.height * 2;
        }
        guiGraphics.blit(ClientUtil.GENERAL_ICONS, this.getX(), this.getY(), u, v, this.width, this.height);
        if (this.isHovered) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip.get(), mouseX, mouseY);
        }
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        List<Component> resolvedTooltip = this.tooltip.get();
        return resolvedTooltip.isEmpty() ? Component.literal((String)"") : Component.translatable((String)"gui.narrate.button", (Object[])new Object[]{resolvedTooltip.get(0)});
    }
}

