/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.tweaks.module.PetalsOnWaterModule;
import org.violetmoon.quark.content.world.module.CherryGroveWaterPetalsModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.world.generator.Generator;

public class CherryGroveWaterPetalsGenerator
extends Generator {
    protected static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static Map<Direction, BlockState> edgeStates = new HashMap<Direction, BlockState>();

    public CherryGroveWaterPetalsGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos chunkCorner) {
        if (CherryGroveWaterPetalsModule.staticEnabled && (double)rand.nextFloat() < CherryGroveWaterPetalsModule.chancePerChunk) {
            block0: for (int i = 0; i < CherryGroveWaterPetalsModule.triesPerChunk; ++i) {
                BlockPos pos = chunkCorner.offset(rand.nextInt(16), 70, rand.nextInt(16));
                Holder biome = this.getBiome((LevelAccessor)worldIn, pos, false);
                if (!CherryGroveWaterPetalsModule.biomes.canSpawn(biome)) continue;
                while (pos.getY() > 10) {
                    if (worldIn.getBlockState(pos.below()).is(Blocks.WATER)) {
                        this.place(worldIn, pos, rand);
                        continue block0;
                    }
                    pos = pos.below();
                }
            }
        }
    }

    public void place(WorldGenRegion worldIn, BlockPos corner, RandomSource rand) {
        int thisSize = 0;
        if (CherryGroveWaterPetalsModule.sizeVariation > 0) {
            int[] sizes = new int[]{CherryGroveWaterPetalsModule.size - CherryGroveWaterPetalsModule.sizeVariation, CherryGroveWaterPetalsModule.size, CherryGroveWaterPetalsModule.size + CherryGroveWaterPetalsModule.sizeVariation};
            thisSize = sizes[rand.nextIntBetweenInclusive(0, 2)];
        } else {
            thisSize = CherryGroveWaterPetalsModule.size;
        }
        if (CherryGroveWaterPetalsModule.useCarpet && Quark.ZETA.modules.isEnabled(LeafCarpetModule.class)) {
            square = CherryGroveWaterPetalsGenerator.getCorePositions(thisSize, corner);
            for (BlockPos pos : square) {
                if (!worldIn.getBlockState(pos).is(Blocks.AIR) || !worldIn.getBlockState(pos.below()).is(Blocks.WATER)) continue;
                worldIn.setBlock(pos, LeafCarpetModule.carpets.get(7).defaultBlockState(), 0);
            }
        } else if (!CherryGroveWaterPetalsModule.useCarpet && Quark.ZETA.modules.isEnabled(PetalsOnWaterModule.class)) {
            square = CherryGroveWaterPetalsGenerator.getCorePositions(thisSize, corner);
            for (BlockPos pos : square) {
                if (!worldIn.getBlockState(pos).is(Blocks.AIR) || !worldIn.getBlockState(pos.below()).is(Blocks.WATER)) continue;
                worldIn.setBlock(pos, CherryGroveWaterPetalsGenerator.makePetalState(4, CARDINAL_DIRECTIONS[rand.nextIntBetweenInclusive(0, 3)]), 0);
            }
            Map<Direction, List<BlockPos>> borders = CherryGroveWaterPetalsGenerator.getBorderPositions(worldIn, square);
            for (Direction d : borders.keySet()) {
                for (BlockPos pos : borders.get(d)) {
                    if (!worldIn.getBlockState(pos.below()).is(Blocks.WATER)) continue;
                    worldIn.setBlock(pos, edgeStates.get(d), 0);
                }
            }
        } else {
            Quark.LOG.debug("could not place Cherry Grove Water Petals due to config");
        }
    }

    public static List<BlockPos> getCorePositions(int size, BlockPos corner) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        ret.add(corner);
        for (int l = 0; l < size; ++l) {
            for (int w = 0; w < size; ++w) {
                ret.add(new BlockPos(corner.getX() + l, corner.getY(), corner.getZ() + w));
            }
        }
        return ret;
    }

    public static Map<Direction, List<BlockPos>> getBorderPositions(WorldGenRegion worldIn, List<BlockPos> core) {
        HashMap<Direction, List<BlockPos>> ret = new HashMap<Direction, List<BlockPos>>();
        ArrayList<BlockPos> northBorder = new ArrayList<BlockPos>();
        ArrayList<BlockPos> eastBorder = new ArrayList<BlockPos>();
        ArrayList<BlockPos> southBorder = new ArrayList<BlockPos>();
        ArrayList<BlockPos> westBorder = new ArrayList<BlockPos>();
        for (BlockPos pos : core) {
            if (worldIn.getBlockState(pos.north()).is(Blocks.AIR)) {
                northBorder.add(pos.north());
            }
            if (worldIn.getBlockState(pos.east()).is(Blocks.AIR)) {
                eastBorder.add(pos.east());
            }
            if (worldIn.getBlockState(pos.south()).is(Blocks.AIR)) {
                southBorder.add(pos.south());
            }
            if (!worldIn.getBlockState(pos.west()).is(Blocks.AIR)) continue;
            westBorder.add(pos.west());
        }
        ret.put(Direction.NORTH, northBorder);
        ret.put(Direction.EAST, eastBorder);
        ret.put(Direction.SOUTH, southBorder);
        ret.put(Direction.WEST, westBorder);
        return ret;
    }

    public static BlockState makePetalState(int amount, Direction direction) {
        return (BlockState)((BlockState)PetalsOnWaterModule.water_pink_petals.defaultBlockState().setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)).setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(amount));
    }

    public static BlockState makeEdgeState(Direction d) {
        return CherryGroveWaterPetalsGenerator.makePetalState(2, d);
    }

    static {
        edgeStates.put(Direction.NORTH, CherryGroveWaterPetalsGenerator.makeEdgeState(Direction.WEST));
        edgeStates.put(Direction.EAST, CherryGroveWaterPetalsGenerator.makeEdgeState(Direction.NORTH));
        edgeStates.put(Direction.SOUTH, CherryGroveWaterPetalsGenerator.makeEdgeState(Direction.EAST));
        edgeStates.put(Direction.WEST, CherryGroveWaterPetalsGenerator.makeEdgeState(Direction.SOUTH));
    }
}

