/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.ai.FoxhoundPlaceToRestGoal;
import org.violetmoon.quark.content.mobs.module.FoxhoundModule;
import org.violetmoon.quark.content.tweaks.ai.WantLoveGoal;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorLivingEntity;

public class Foxhound
extends Wolf
implements Enemy {
    public static final ResourceKey<LootTable> FOXHOUND_LOOT_TABLE = Quark.asResourceKey(Registries.LOOT_TABLE, "entities/foxhound");
    private static final EntityDataAccessor<Boolean> TEMPTATION = SynchedEntityData.defineId(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_BLUE = SynchedEntityData.defineId(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TATERING = SynchedEntityData.defineId(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.defineId(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_RESTING = SynchedEntityData.defineId(Foxhound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int timeUntilPotatoEmerges = 0;
    private int ticksUntilICanSleep = 0;

    public Foxhound(EntityType<? extends Foxhound> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 4.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 4.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLLAR_COLOR, (Object)DyeColor.ORANGE.getId());
        builder.define(TEMPTATION, (Object)false);
        builder.define(IS_BLUE, (Object)false);
        builder.define(TATERING, (Object)false);
        builder.define(IS_RESTING, (Object)false);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired();
    }

    public boolean requiresCustomPersistence() {
        return this.isTame();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn) {
        Holder biome = worldIn.getBiome(BlockPos.containing((Position)this.position()));
        if (biome.is(Biomes.SOUL_SAND_VALLEY.location())) {
            this.setBlue(true);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void tick() {
        BlockPos below;
        BlockEntity tile;
        Level level;
        block16: {
            LivingEntity owner;
            block17: {
                super.tick();
                level = this.level();
                if (this.ticksUntilICanSleep > 0) {
                    --this.ticksUntilICanSleep;
                }
                if (!level.isClientSide && this.timeUntilPotatoEmerges > 0) {
                    if (--this.timeUntilPotatoEmerges == 0) {
                        this.setTatering(false);
                        ItemStack stack = new ItemStack((ItemLike)TinyPotatoModule.tiny_potato);
                        stack.set(QuarkDataComponents.IS_ANGRY, (Object)true);
                        this.spawnAtLocation(stack);
                        this.playSound(QuarkSounds.BLOCK_POTATO_HURT, 1.0f, 1.0f);
                    } else if (!this.isTatering()) {
                        this.setTatering(true);
                    }
                }
                if (!WantLoveGoal.needsPets((TamableAnimal)this) || (owner = this.getOwner()) == null || !(owner.distanceToSqr((Entity)this) < 1.0) || owner.isInWater() || owner.fireImmune()) break block16;
                if (!(owner instanceof Player)) break block17;
                Player player = (Player)owner;
                if (player.getAbilities().invulnerable) break block16;
            }
            owner.igniteForSeconds(5.0f);
        }
        Vec3 pos = this.position();
        if (level.isClientSide && !this.isBaby() ^ this.random.nextBoolean()) {
            SimpleParticleType particle = ParticleTypes.FLAME;
            if (this.isResting()) {
                particle = ParticleTypes.SMOKE;
            } else if (this.isBlue()) {
                particle = ParticleTypes.SOUL_FIRE_FLAME;
            }
            level.addParticle((ParticleOptions)particle, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            if (this.isTatering() && this.random.nextDouble() < 0.1) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                level.playLocalSound(pos.x, pos.y, pos.z, QuarkSounds.ENTITY_FOXHOUND_CRACKLE, this.getSoundSource(), 1.0f, 1.0f, false);
            }
        }
        if (this.isTame() && FoxhoundModule.foxhoundsSpeedUpFurnaces && (tile = level.getBlockEntity(below = this.blockPosition().below())) instanceof AbstractFurnaceBlockEntity) {
            List foxhounds;
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)tile;
            int cookTime = furnace.cookingProgress;
            if (cookTime > 0 && cookTime % 3 == 0 && !(foxhounds = level.getEntitiesOfClass(Foxhound.class, new AABB(this.blockPosition()), fox -> fox != null && fox.isTame())).isEmpty() && foxhounds.getFirst() == this) {
                furnace.cookingProgress = furnace.cookingProgress == 3 ? 5 : Math.min(furnace.cookingTotalTime - 1, cookTime + 1);
                LivingEntity livingEntity = this.getOwner();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)livingEntity;
                    FoxhoundModule.foxhoundFurnaceTrigger.trigger(sp);
                }
            }
        }
    }

    public boolean isInWaterOrRain() {
        return false;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return FOXHOUND_LOOT_TABLE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FoxhoundPlaceToRestGoal(this, 0.8, FoxhoundPlaceToRestGoal.Target.LIT_FURNACE));
        this.goalSelector.addGoal(7, (Goal)new FoxhoundPlaceToRestGoal(this, 0.8, FoxhoundPlaceToRestGoal.Target.FURNACE));
        this.goalSelector.addGoal(8, (Goal)new FoxhoundPlaceToRestGoal(this, 0.8, FoxhoundPlaceToRestGoal.Target.GLOWING));
        this.goalSelector.addGoal(9, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new BegGoal((Wolf)this, 8.0f));
        this.goalSelector.addGoal(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, target -> target instanceof Sheep || target instanceof Rabbit));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, target -> !this.isTame() && target.level().getDifficulty() != Difficulty.PEACEFUL));
    }

    public int getRemainingPersistentAngerTime() {
        if (!this.isTame() && this.level().getDifficulty() != Difficulty.PEACEFUL) {
            return 0;
        }
        return super.getRemainingPersistentAngerTime();
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && entityIn instanceof Player) {
            return false;
        }
        if (entityIn.getType().fireImmune()) {
            if (entityIn instanceof Player) {
                return false;
            }
            return super.doHurtTarget(entityIn);
        }
        boolean flag = entityIn.hurt(this.level().damageSources().onFire(), (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (flag) {
            ServerPlayer player;
            if (entityIn instanceof ServerPlayer && (player = (ServerPlayer)entityIn).isBlocking()) {
                ((AccessorLivingEntity)player).quark$blockUsingShield((LivingEntity)this);
            }
            entityIn.igniteForSeconds(5.0f);
        }
        return flag;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            this.setResting(false);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        InteractionResult res;
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.DEBUG_STICK) && !player.level().isClientSide()) {
            if (this.isResting()) {
                player.sendSystemMessage((Component)Component.literal((String)"setResting(false)"));
                this.setResting(false);
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"setSleeping(true)"));
                this.setResting(true);
                return InteractionResult.CONSUME;
            }
        }
        if (itemstack.getItem() == Items.BONE && !this.isTame()) {
            return InteractionResult.PASS;
        }
        Level level = this.level();
        if (this.isTame()) {
            if (this.timeUntilPotatoEmerges <= 0 && itemstack.is(TinyPotatoModule.tiny_potato.asItem())) {
                this.timeUntilPotatoEmerges = 600;
                this.playSound(QuarkSounds.ENTITY_FOXHOUND_EAT, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (!(itemstack.isEmpty() || itemstack.getItem() != Items.COAL || level.getDifficulty() != Difficulty.PEACEFUL && !player.getAbilities().invulnerable && player.getEffect(MobEffects.FIRE_RESISTANCE) == null || level.isClientSide)) {
            if (this.random.nextDouble() < FoxhoundModule.tameChance) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setInSittingPose(true);
                this.setHealth(20.0f);
                level.broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                level.broadcastEntityEvent((Entity)this, (byte)6);
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if ((res = super.mobInteract(player, hand)).consumesAction()) {
            this.setResting(false);
            if (this.isOrderedToSit()) {
                this.setInSittingPose(true);
            }
        }
        return res;
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        return super.canMate(otherAnimal) && otherAnimal instanceof Foxhound;
    }

    public Wolf getBreedOffspring(@NotNull ServerLevel sworld, @NotNull AgeableMob otherParent) {
        Foxhound kid = new Foxhound(FoxhoundModule.foxhoundType, this.level());
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            kid.setOwnerUUID(uuid);
            kid.setTame(true, true);
        }
        if (this.isBlue()) {
            kid.setBlue(true);
        }
        return kid;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("OhLawdHeComin", this.timeUntilPotatoEmerges);
        compound.putBoolean("IsSlep", this.isResting());
        compound.putBoolean("IsBlue", this.isBlue());
        compound.putInt("ticksUntilICanSleep", this.ticksUntilICanSleep);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.timeUntilPotatoEmerges = compound.getInt("OhLawdHeComin");
        this.setResting(compound.getBoolean("IsSlep"));
        this.setBlue(compound.getBoolean("IsBlue"));
        this.ticksUntilICanSleep = compound.getInt("ticksUntilICanSleep");
    }

    protected SoundEvent getAmbientSound() {
        if (this.isResting()) {
            return null;
        }
        if (this.isAngry()) {
            return QuarkSounds.ENTITY_FOXHOUND_GROWL;
        }
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 10.0f ? QuarkSounds.ENTITY_FOXHOUND_WHINE : QuarkSounds.ENTITY_FOXHOUND_PANT;
        }
        return QuarkSounds.ENTITY_FOXHOUND_IDLE;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_FOXHOUND_HURT;
    }

    protected SoundEvent getDeathSound() {
        return QuarkSounds.ENTITY_FOXHOUND_DIE;
    }

    public boolean isBlue() {
        return (Boolean)this.entityData.get(IS_BLUE);
    }

    public void setBlue(boolean blue) {
        this.entityData.set(IS_BLUE, (Object)blue);
    }

    public boolean isTatering() {
        return (Boolean)this.entityData.get(TATERING);
    }

    public void setTatering(boolean tatering) {
        this.entityData.set(TATERING, (Object)tatering);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos.below()).is(FoxhoundModule.foxhoundSpawnableTag) ? 10.0f : (float)worldIn.getRawBrightness(pos, 0) - 0.5f;
    }

    public static boolean spawnPredicate(EntityType<? extends Foxhound> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return world.getDifficulty() != Difficulty.PEACEFUL && world.getBlockState(pos.below()).is(FoxhoundModule.foxhoundSpawnableTag);
    }

    public boolean isSleeping() {
        return this.isResting();
    }

    public boolean isStanding() {
        return this.getPose() == Pose.STANDING;
    }

    public void setStanding(boolean standing) {
        this.setPose(Pose.STANDING);
    }

    public void startSleeping(BlockPos pos) {
        super.startSleeping(pos);
        this.setResting(true);
    }

    public void stopSleeping() {
        super.stopSleeping();
        this.setResting(false);
    }

    public boolean canTeleportTo(@NotNull BlockPos teleportPos) {
        if (!super.canTeleportTo(teleportPos)) {
            PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)teleportPos);
            if (pathtype != PathType.DAMAGE_FIRE && pathtype != PathType.DANGER_FIRE) {
                return false;
            }
            if (!this.canFlyToOwner() && this.level().getBlockState(teleportPos.below()).getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockDistance = teleportPos.subtract((Vec3i)this.blockPosition());
            return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockDistance));
        }
        return super.canTeleportTo(teleportPos);
    }

    public void tryToTeleportToOwner() {
        if (!this.isStanding()) {
            this.setStanding(true);
        }
        super.tryToTeleportToOwner();
    }

    public boolean isResting() {
        return (Boolean)this.entityData.get(IS_RESTING);
    }

    public void setResting(boolean resting) {
        this.entityData.set(IS_RESTING, (Object)resting);
        if (!resting) {
            this.ticksUntilICanSleep = 100;
        }
    }

    public boolean canRest() {
        return this.ticksUntilICanSleep <= 0;
    }
}

