/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.tweaks.module.DragonScalesModule;

public class ElytraDuplicationRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(ElytraDuplicationRecipe::new);

    public ElytraDuplicationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != 2) {
            return false;
        }
        boolean hasElytra = false;
        boolean hasScale = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.getItem() instanceof ElytraItem) {
                hasElytra = true;
                continue;
            }
            if (stack.getItem() != DragonScalesModule.dragon_scale) continue;
            hasScale = true;
        }
        return hasElytra && hasScale;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        return this.getResultItem(provider);
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        ItemStack stack = new ItemStack((ItemLike)Items.ELYTRA);
        return stack;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList ret = NonNullList.withSize((int)inv.ingredientCount(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.getItem() != Items.ELYTRA) continue;
            ret.set(i, (Object)stack.copy());
        }
        return ret;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.withSize((int)2, (Object)Ingredient.EMPTY);
        list.set(0, (Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.ELYTRA)}));
        list.set(1, (Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)DragonScalesModule.dragon_scale)}));
        return list;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

