/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.util.RotationHelper;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.util.SimpleInventoryBlockEntity;

public abstract class AbstractEnchantingTableBlockEntity
extends SimpleInventoryBlockEntity
implements Nameable {
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation;
    public float bookRotationPrev;
    public float targetRotation;
    private static final Random rand = new Random();
    private Component customName;

    public AbstractEnchantingTableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public int getContainerSize() {
        return 3;
    }

    public boolean isAutomationEnabled() {
        return false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.hasCustomName()) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
    }

    public void tick() {
        this.performVanillaUpdate();
    }

    private void performVanillaUpdate() {
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        Player entityplayer = this.level.getNearestPlayer((double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), 3.0, false);
        if (entityplayer != null) {
            double xDiff = entityplayer.getX() - (double)((float)this.worldPosition.getX() + 0.5f);
            double zDiff = entityplayer.getZ() - (double)((float)this.worldPosition.getZ() + 0.5f);
            this.targetRotation = (float)Mth.atan2((double)zDiff, (double)xDiff);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float f1 = this.flipT;
                do {
                    this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
                } while (f1 == this.flipT);
            }
        } else {
            this.targetRotation += 0.02f;
            this.bookSpread -= 0.1f;
        }
        this.bookRotation = RotationHelper.wrapRadians(this.bookRotation);
        this.targetRotation = RotationHelper.wrapRadians(this.targetRotation);
        float targetDiff = RotationHelper.wrapRadians(this.targetRotation - this.bookRotation);
        this.bookRotation += targetDiff * 0.4f;
        this.bookSpread = Mth.clamp((float)this.bookSpread, (float)0.0f, (float)1.0f);
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public void dropItem(int i) {
        ItemStack stack = this.getItem(i);
        if (!stack.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
        }
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)"container.enchant");
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component customNameIn) {
        this.customName = customNameIn;
    }

    public void inventoryChanged(int i) {
        this.sync();
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    public void sync() {
        MiscUtil.syncTE((BlockEntity)this);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

