/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.item.boat;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.item.boat.IQuarkBoat;

public class QuarkBoat
extends Boat
implements IQuarkBoat {
    private static final EntityDataAccessor<String> DATA_QUARK_TYPE = SynchedEntityData.defineId(QuarkBoat.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public QuarkBoat(EntityType<? extends Boat> entityType, Level world) {
        super(entityType, world);
    }

    public QuarkBoat(Level world, double x, double y, double z) {
        this(WoodSetHandler.quarkBoatEntityType, world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_QUARK_TYPE, (Object)"blossom");
    }

    public String getQuarkBoatType() {
        return (String)this.entityData.get(DATA_QUARK_TYPE);
    }

    public void setQuarkBoatType(String type) {
        this.entityData.set(DATA_QUARK_TYPE, (Object)type);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("QuarkType", this.getQuarkBoatType());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("QuarkType", 8)) {
            this.setQuarkBoatType(tag.getString("QuarkType"));
        }
    }

    public ItemEntity spawnAtLocation(ItemLike itemLike) {
        if (BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath().contains("_planks")) {
            return super.spawnAtLocation((ItemLike)this.getQuarkBoatTypeObj().planks());
        }
        return super.spawnAtLocation(itemLike);
    }

    @NotNull
    public Item getDropItem() {
        return this.getQuarkBoatTypeObj().boat();
    }

    @NotNull
    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }

    public void setVariant(@NotNull Boat.Type type) {
    }

    @Override
    public void setQuarkBoatTypeObj(WoodSetHandler.QuarkBoatType type) {
        this.setQuarkBoatType(type.name());
    }

    @Override
    public WoodSetHandler.QuarkBoatType getQuarkBoatTypeObj() {
        return WoodSetHandler.getQuarkBoatType(this.getQuarkBoatType());
    }
}

