/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.world.module.MonsterBoxModule;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public class MonsterBoxBlockEntity
extends ZetaBlockEntity {
    private int breakProgress;

    public MonsterBoxBlockEntity(BlockPos pos, BlockState state) {
        super(MonsterBoxModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonsterBoxBlockEntity be) {
        boolean doBreak;
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (level.isClientSide) {
            level.addParticle((ParticleOptions)(be.breakProgress == 0 ? ParticleTypes.FLAME : ParticleTypes.LARGE_SMOKE), (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
        boolean bl = doBreak = be.breakProgress > 0;
        if (!doBreak) {
            List players = level.players();
            for (Player p : players) {
                if (!(p.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < MonsterBoxModule.activationRange * MonsterBoxModule.activationRange) || p.isSpectator()) continue;
                doBreak = true;
                break;
            }
        }
        if (doBreak) {
            if (be.breakProgress == 0) {
                level.playSound(null, pos, QuarkSounds.BLOCK_MONSTER_BOX_GROWL, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            ++be.breakProgress;
            if (be.breakProgress > 40) {
                be.spawnMobs();
                level.levelEvent(2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
                level.removeBlock(pos, false);
            }
        }
    }

    private void spawnMobs() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getBlockPos();
            LootTable loot = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)MonsterBoxModule.MONSTER_BOX_SPAWNS_LOOT_TABLE));
            LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this);
            LootParams ctx = builder.create(LootContextParamSets.BLOCK);
            int mobCount = MonsterBoxModule.minMobCount + this.level.random.nextInt(Math.max(MonsterBoxModule.maxMobCount - MonsterBoxModule.minMobCount + 1, 1));
            for (int i = 0; i < mobCount; ++i) {
                loot.getRandomItemsRaw(ctx, stack -> {
                    SpawnEggItem egg;
                    EntityType entitytype;
                    Entity e = null;
                    Item patt0$temp = stack.getItem();
                    if (patt0$temp instanceof SpawnEggItem && (e = (entitytype = (egg = (SpawnEggItem)patt0$temp).getType(stack)).spawn(serverLevel, stack, null, pos, MobSpawnType.SPAWNER, true, true)) != null) {
                        double motionMultiplier = 0.4;
                        e.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                        double mx = ((double)this.level.random.nextFloat() - 0.5) * motionMultiplier;
                        double my = ((double)this.level.random.nextFloat() - 0.5) * motionMultiplier;
                        double mz = ((double)this.level.random.nextFloat() - 0.5) * motionMultiplier;
                        e.setDeltaMovement(mx, my, mz);
                        e.getPersistentData().putBoolean("quark:monster_box_spawned", true);
                    }
                });
            }
            serverLevel.getLevel().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }
}

