/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.undergroundstyle.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.undergroundstyle.base.UndergroundStyleGenerator;
import org.violetmoon.zeta.util.MiscUtil;

public abstract class UndergroundStyle {
    private static final TagKey<Block> UNDERGROUND_BIOME_REPLACEABLE = Quark.asTagKey(Registries.BLOCK, "underground_biome_replaceable");

    public boolean canReplace(BlockState state) {
        return state.canBeReplaced() || state.is(UNDERGROUND_BIOME_REPLACEABLE);
    }

    public final void fill(UndergroundStyleGenerator.Context context, BlockPos pos) {
        WorldGenRegion world = context.world;
        BlockState state = world.getBlockState(pos);
        if (state.getDestroySpeed((BlockGetter)world, pos) == -1.0f) {
            return;
        }
        if (this.isFloor((LevelAccessor)world, pos, state)) {
            this.fillFloor(context, pos, state);
        } else if (this.isCeiling((LevelAccessor)world, pos, state)) {
            this.fillCeiling(context, pos, state);
        } else if (this.isWall((LevelAccessor)world, pos, state)) {
            this.fillWall(context, pos, state);
        } else if (this.isInside(state)) {
            this.fillInside(context, pos, state);
        }
    }

    public abstract void fillFloor(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillCeiling(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillWall(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillInside(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public boolean isFloor(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.isSolidRender((BlockGetter)world, pos) || !this.canReplace(state)) {
            return false;
        }
        BlockPos upPos = pos.above();
        return world.isEmptyBlock(upPos) || world.getBlockState(upPos).canBeReplaced();
    }

    public boolean isCeiling(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.isSolidRender((BlockGetter)world, pos) || !this.canReplace(state)) {
            return false;
        }
        BlockPos downPos = pos.below();
        return world.isEmptyBlock(downPos) || world.getBlockState(downPos).canBeReplaced();
    }

    public boolean isWall(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.isSolidRender((BlockGetter)world, pos) || !this.canReplace(state)) {
            return false;
        }
        return this.isBorder(world, pos);
    }

    public Direction getBorderSide(LevelAccessor world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (Direction facing : MiscUtil.HORIZONTALS) {
            BlockPos offsetPos = pos.relative(facing);
            BlockState stateAt = world.getBlockState(offsetPos);
            if ((state == stateAt || !world.isEmptyBlock(offsetPos)) && !stateAt.canBeReplaced()) continue;
            return facing;
        }
        return null;
    }

    public boolean isBorder(LevelAccessor world, BlockPos pos) {
        return this.getBorderSide(world, pos) != null;
    }

    public boolean isInside(BlockState state) {
        return state.is(UNDERGROUND_BIOME_REPLACEABLE);
    }
}

