/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.tools.entity.rang.AbstractPickarang;

public class PickarangRenderer
extends EntityRenderer<AbstractPickarang<?>> {
    public PickarangRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(AbstractPickarang<?> entity, float yaw, float partialTicks, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        if (entity.tickCount >= 2) {
            matrix.pushPose();
            matrix.translate(0.0, 0.2, 0.0);
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            Minecraft mc = Minecraft.getInstance();
            float time = (float)entity.tickCount + (mc.isPaused() ? 0.0f : partialTicks);
            matrix.mulPose(Axis.ZP.rotationDegrees(time * 20.0f));
            mc.getItemRenderer().renderStatic(entity.getStack(), ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrix, buffer, (Level)Minecraft.getInstance().level, 0);
            matrix.popPose();
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AbstractPickarang<?> entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

