/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.automation.module.GravisandModule;

public class Gravisand
extends FallingBlockEntity {
    private static final EntityDataAccessor<Float> DIRECTION = SynchedEntityData.defineId(Gravisand.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final String TAG_DIRECTION = "fallDirection";

    public Gravisand(EntityType<? extends Gravisand> type, Level world) {
        super(type, world);
        this.blockState = GravisandModule.gravisand.defaultBlockState();
    }

    public Gravisand(Level world, double x, double y, double z, float direction) {
        this(GravisandModule.gravisandType, world);
        this.blockState = GravisandModule.gravisand.defaultBlockState();
        this.blocksBuilding = true;
        this.setPos(x, y + (double)((1.0f - this.getBbHeight()) / 2.0f), z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(new BlockPos((Vec3i)this.blockPosition()));
        this.entityData.set(DIRECTION, (Object)Float.valueOf(direction));
    }

    public void tick() {
        boolean aboveHasCollision;
        super.tick();
        BlockPos blockpos1 = this.blockPosition();
        boolean bl = aboveHasCollision = !this.level().getBlockState(blockpos1.above()).getCollisionShape((BlockGetter)this.level(), blockpos1.above()).isEmpty();
        if (!this.level().isClientSide && this.getFallDirection() > 0.0f && !this.isRemoved() && aboveHasCollision) {
            boolean flag4;
            Block block = this.getBlockState().getBlock();
            BlockState blockstate = this.level().getBlockState(blockpos1);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, 0.5, 0.7));
            boolean flag2 = blockstate.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockpos1, Direction.UP, ItemStack.EMPTY, Direction.DOWN));
            boolean flag3 = FallingBlock.isFree((BlockState)this.level().getBlockState(blockpos1.above()));
            boolean bl2 = flag4 = this.getBlockState().canSurvive((LevelReader)this.level(), blockpos1) && !flag3;
            if (flag2 && flag4) {
                if (this.level().setBlock(blockpos1, this.getBlockState(), 3)) {
                    ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos1, this.level().getBlockState(blockpos1)));
                    this.discard();
                } else if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.discard();
                    this.callOnBrokenAfterFall(block, blockpos1);
                    this.spawnAtLocation((ItemLike)block);
                }
            } else {
                this.discard();
                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.callOnBrokenAfterFall(block, blockpos1);
                    this.spawnAtLocation((ItemLike)block);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIRECTION, (Object)Float.valueOf(0.0f));
    }

    public void move(@NotNull MoverType type, @NotNull Vec3 vec) {
        if (type == MoverType.SELF) {
            super.move(type, vec.scale((double)(this.getFallDirection() * -1.0f)));
        } else {
            super.move(type, vec);
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    private float getFallDirection() {
        return ((Float)this.entityData.get(DIRECTION)).floatValue();
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat(TAG_DIRECTION, this.getFallDirection());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(DIRECTION, (Object)Float.valueOf(compound.getFloat(TAG_DIRECTION)));
    }
}

