/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks", antiOverlap={"nerb"})
public class AutomaticRecipeUnlockModule
extends ZetaModule {
    @Config(description="A list of recipe names that should NOT be added in by default")
    public static List<String> ignoredRecipes = Lists.newArrayList();
    @Config
    public static boolean forceLimitedCrafting = false;
    @Config
    public static boolean disableRecipeBook = false;
    @Config(description="If enabled, advancements granting recipes will be stopped from loading, potentially reducing the lagspike on first world join.")
    public static boolean filterRecipeAdvancements = true;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @PlayEvent
    public void onPlayerLoggedIn(ZPlayer.LoggedIn event) {
        int shift;
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || !((player2 = (player = (ServerPlayer)player2).getServer()) instanceof MinecraftServer)) {
            return;
        }
        Player server = player2;
        Level level = player.level();
        ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(server.getRecipeManager().getRecipes());
        recipes.removeIf(recipe -> recipe == null || ignoredRecipes.contains(Objects.toString(recipe.id())) || recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).isEmpty());
        int idx = 0;
        int maxShift = 1000;
        int size = recipes.size();
        do {
            shift = size - idx;
            int effShift = Math.min(maxShift, shift);
            List sectionedRecipes = recipes.subList(idx, idx + effShift);
            player.awardRecipes(sectionedRecipes);
            idx += effShift;
        } while (shift > maxShift);
        if (forceLimitedCrafting) {
            ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_LIMITED_CRAFTING)).set(true, (MinecraftServer)server);
        }
    }

    public static ImmutableMap.Builder<ResourceLocation, AdvancementHolder> removeRecipeAdvancements(ImmutableMap.Builder<ResourceLocation, AdvancementHolder> advancements) {
        if (!staticEnabled || !filterRecipeAdvancements) {
            return advancements;
        }
        HashMap copy = new HashMap(Map.copyOf(advancements.build()));
        ImmutableMap.Builder replacements = ImmutableMap.builder();
        int removeCount = 0;
        for (Map.Entry entry : copy.entrySet()) {
            Advancement advancement = ((AdvancementHolder)entry.getValue()).value();
            if (!((ResourceLocation)entry.getKey()).getPath().startsWith("recipes/") || !advancement.criteria().containsKey("has_the_recipe")) continue;
            HashMap replacementCriteria = new HashMap(advancement.criteria());
            replacementCriteria.remove("has_the_recipe");
            Advancement replacement = new Advancement(advancement.parent(), advancement.display(), advancement.rewards(), replacementCriteria, advancement.requirements(), advancement.sendsTelemetryEvent(), advancement.name());
            AdvancementHolder replacementHolder = new AdvancementHolder(((AdvancementHolder)entry.getValue()).id(), replacement);
            replacements.put((Object)((ResourceLocation)entry.getKey()), (Object)replacementHolder);
            ++removeCount;
        }
        Quark.LOG.info("[Automatic Recipe Unlock] Removed {} recipe advancements", (Object)removeCount);
        return replacements;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AutomaticRecipeUnlockModule {
        @PlayEvent
        public void onInitGui(ZScreen.Init.Post event) {
            LocalPlayer player = Minecraft.getInstance().player;
            Screen gui = event.getScreen();
            if (disableRecipeBook && player != null && gui instanceof RecipeUpdateListener) {
                player.getRecipeBook().getBookSettings().setOpen(RecipeBookType.CRAFTING, false);
                List widgets = event.getListenersList();
                for (GuiEventListener eventListener : widgets) {
                    if (!(eventListener instanceof ImageButton)) continue;
                    event.removeListener(eventListener);
                    return;
                }
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            Minecraft client = Minecraft.getInstance();
            if (client.player != null && client.player.tickCount < 20) {
                Deque toastQueue = client.getToasts().queued;
                for (Toast toast : toastQueue) {
                    if (!(toast instanceof RecipeToast)) continue;
                    RecipeToast recipeToast = (RecipeToast)toast;
                    if (recipeToast.recipes.size() <= 100) continue;
                    toastQueue.remove(toast);
                    return;
                }
            }
        }
    }
}

