/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import org.violetmoon.quark.content.tweaks.ai.WantLoveGoal;

public class NuzzleGoal
extends Goal {
    private final TamableAnimal creature;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigation petPathfinder;
    private int timeUntilRebuildPath;
    private final float maxDist;
    private final float whineDist;
    private int whineCooldown;
    private float oldWaterCost;
    private final SoundEvent whine;

    public NuzzleGoal(TamableAnimal creature, double followSpeed, float maxDist, float whineDist, SoundEvent whine) {
        this.creature = creature;
        this.followSpeed = followSpeed;
        this.petPathfinder = creature.getNavigation();
        this.maxDist = maxDist;
        this.whineDist = whineDist;
        this.whine = whine;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        if (!(creature.getNavigation() instanceof GroundPathNavigation) && !(creature.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for NuzzleOwnerGoal");
        }
    }

    public boolean canUse() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        LivingEntity living = this.creature.getOwner();
        if (living == null || living.isSpectator() || this.creature.isOrderedToSit()) {
            return false;
        }
        this.owner = living;
        return true;
    }

    public boolean canContinueToUse() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.petPathfinder.isDone() && this.creature.distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.creature.isOrderedToSit();
    }

    public void start() {
        this.timeUntilRebuildPath = 0;
        this.whineCooldown = 10;
        this.oldWaterCost = this.creature.getPathfindingMalus(PathType.WATER);
        this.creature.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.petPathfinder.stop();
        this.creature.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.creature.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.creature.getMaxHeadXRot());
        if (!this.creature.isOrderedToSit() && --this.timeUntilRebuildPath <= 0) {
            this.timeUntilRebuildPath = 10;
            this.petPathfinder.moveTo((Entity)this.owner, this.followSpeed);
        }
        if (this.creature.distanceToSqr((Entity)this.owner) < (double)this.whineDist && --this.whineCooldown <= 0) {
            this.whineCooldown = 80 + this.creature.getRandom().nextInt(40);
            this.creature.playSound(this.whine, 1.0f, 0.5f + (float)Math.random() * 0.5f);
        }
    }
}

