/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.handler;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;

public class SimilarBlockTypeHandler {
    public static List<String> getBasicShulkerBoxes() {
        return ImmutableSet.of((Object)Blocks.WHITE_SHULKER_BOX, (Object)Blocks.ORANGE_SHULKER_BOX, (Object)Blocks.MAGENTA_SHULKER_BOX, (Object)Blocks.LIGHT_BLUE_SHULKER_BOX, (Object)Blocks.YELLOW_SHULKER_BOX, (Object)Blocks.LIME_SHULKER_BOX, (Object[])new Block[]{Blocks.PINK_SHULKER_BOX, Blocks.GRAY_SHULKER_BOX, Blocks.LIGHT_GRAY_SHULKER_BOX, Blocks.CYAN_SHULKER_BOX, Blocks.PURPLE_SHULKER_BOX, Blocks.BLUE_SHULKER_BOX, Blocks.BROWN_SHULKER_BOX, Blocks.GREEN_SHULKER_BOX, Blocks.RED_SHULKER_BOX, Blocks.BLACK_SHULKER_BOX}).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).map(Objects::toString).collect(Collectors.toList());
    }

    public static boolean isShulkerBox(ItemStack stack) {
        return SimilarBlockTypeHandler.isShulkerBox(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())) && !stack.isEmpty() && stack.getMaxStackSize() == 1;
    }

    public static boolean isShulkerBox(ResourceLocation loc) {
        if (loc == null) {
            return false;
        }
        String locStr = loc.toString();
        if (QuarkGeneralConfig.shulkerBoxes.contains(locStr)) {
            return true;
        }
        return QuarkGeneralConfig.interpretShulkerBoxLikeBlocks && locStr.contains("shulker_box");
    }
}

