/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.feature;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;

public class GlowExtrasFeature
extends Feature<NoneFeatureConfiguration> {
    public GlowExtrasFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static List<PlacementModifier> placed() {
        return Arrays.asList(CountPlacement.of((int)200), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome());
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        WorldGenLevel worldgenlevel = config.level();
        BlockPos blockpos = config.origin();
        RandomSource rng = config.random();
        BlockPos.MutableBlockPos setPos = new BlockPos.MutableBlockPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
        int horiz = 2;
        int vert = 6;
        float chance = 0.5f;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                block2: for (int k = -6; k < 7; ++k) {
                    setPos.set(blockpos.getX() + i, blockpos.getY() + k, blockpos.getZ() + j);
                    if (!(rng.nextFloat() < 0.5f) || !worldgenlevel.isStateAtPosition((BlockPos)setPos, BlockBehaviour.BlockStateBase::isAir)) continue;
                    double res = rng.nextDouble();
                    if (res > 0.85) {
                        if (!worldgenlevel.isStateAtPosition(setPos.below(), s -> s.getBlock() == Blocks.DEEPSLATE)) continue;
                        worldgenlevel.setBlock((BlockPos)setPos, GlimmeringWealdModule.glow_lichen_growth.defaultBlockState(), 2);
                        continue;
                    }
                    if (!(res > 0.35)) continue;
                    for (Direction dir : Direction.values()) {
                        if (!worldgenlevel.isStateAtPosition(setPos.relative(dir), s -> s.getBlock() == Blocks.DEEPSLATE)) continue;
                        BlockState place = Blocks.GLOW_LICHEN.defaultBlockState();
                        for (Direction dir2 : Direction.values()) {
                            BooleanProperty prop = GlowLichenBlock.getFaceProperty((Direction)dir2);
                            place = (BlockState)place.setValue((Property)prop, (Comparable)Boolean.valueOf(dir == dir2));
                        }
                        worldgenlevel.setBlock((BlockPos)setPos, place, 2);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }
}

