/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.block.RopeBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="building", antiOverlap={"supplementaries"})
public class RopeModule
extends ZetaModule {
    @Hint
    public static Block rope;
    @Config(description="Set to true to allow ropes to move Tile Entities even if Pistons Push TEs is disabled.\nNote that ropes will still use the same blacklist.")
    public static boolean forceEnableMoveTileEntities;
    @Config
    public static boolean enableDispenserBehavior;

    @LoadEvent
    public final void register(ZRegister event) {
        rope = new RopeBlock("rope", this, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).ignitedByLava().strength(0.5f).sound(SoundType.WOOL));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        if (enableDispenserBehavior) {
            DispenserBlock.DISPENSER_REGISTRY.put(rope.asItem(), new BehaviourRope());
        } else {
            DispenserBlock.DISPENSER_REGISTRY.remove(rope.asItem());
        }
    }

    static {
        forceEnableMoveTileEntities = false;
        enableDispenserBehavior = true;
    }

    public static class BehaviourRope
    extends OptionalDispenseItemBehavior {
        @NotNull
        protected ItemStack execute(BlockSource source, @NotNull ItemStack stack) {
            Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(facing);
            ServerLevel world = source.level();
            this.setSuccess(false);
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() == rope) {
                if (((RopeBlock)rope).pullDown((Level)world, pos)) {
                    this.setSuccess(true);
                    stack.shrink(1);
                    return stack;
                }
            } else if (world.isEmptyBlock(pos) && rope.defaultBlockState().canSurvive((LevelReader)world, pos)) {
                SoundType soundtype = rope.getSoundType(state, (LevelReader)world, pos, null);
                world.setBlockAndUpdate(pos, rope.defaultBlockState());
                world.playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                this.setSuccess(true);
                stack.shrink(1);
                return stack;
            }
            return stack;
        }
    }
}

