/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.network.message;

import java.util.UUID;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.violetmoon.quark.base.network.QuarkNetwork;
import org.violetmoon.quark.catnip.net.base.BasePacketPayload;
import org.violetmoon.quark.catnip.net.base.ClientboundPacketPayload;
import org.violetmoon.quark.content.management.module.ItemSharingModule;

public record ShareItemS2CMessage(UUID senderUuid, Component senderName, ItemStack stack) implements ClientboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ShareItemS2CMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ShareItemS2CMessage::senderUuid, (StreamCodec)ComponentSerialization.STREAM_CODEC, ShareItemS2CMessage::senderName, (StreamCodec)ItemStack.STREAM_CODEC, ShareItemS2CMessage::stack, ShareItemS2CMessage::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer player) {
        if (Minecraft.getInstance().isBlocked(this.senderUuid)) {
            return;
        }
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.senderName, ItemSharingModule.createStackComponent(this.stack)}), null, new GuiMessageTag(14595203, null, null, "Quark shared item"));
    }

    @Override
    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QuarkNetwork.SHARE_ITEM_S2C_MESSAGE;
    }
}

