/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.client.screen;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;

public class VariantSelectorScreen
extends Screen {
    private float timeIn = 0.0f;
    private int slotSelected = -1;
    private final Minecraft mc;
    private final KeyMapping key;
    private final String currentVariant;
    private final List<Pair<String, @Nullable Block>> variants;
    private final List<DrawStack> drawStacks = new ArrayList<DrawStack>();

    public VariantSelectorScreen(Block originalBlock, KeyMapping key, String currentVariant, List<String> visibleVariants) {
        super((Component)Component.empty());
        this.mc = Minecraft.getInstance();
        this.key = key;
        this.currentVariant = currentVariant;
        this.variants = new ArrayList<Pair<String, Block>>();
        this.variants.add((Pair<String, Block>)Pair.of((Object)"", (Object)originalBlock));
        for (String v : visibleVariants) {
            Block variantBlock = VariantSelectorModule.getVariantBlockFromOriginal(originalBlock, v);
            this.variants.add((Pair<String, Block>)Pair.of((Object)v, (Object)variantBlock));
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mx, int my, float delta) {
        int activeSegment;
        super.render(guiGraphics, mx, my, delta);
        this.timeIn += delta;
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 50;
        int segments = this.variants.size();
        float degPer = (float)Math.PI * 2 / (float)segments;
        float pad = -((float)Math.PI / (float)segments) + 1.5707964f;
        double angle = VariantSelectorScreen.mouseAngle(x, y, mx, my);
        double dist = (x - mx) * (x - mx) + (y - my) * (y - my);
        int n = activeSegment = dist > 64.0 ? (int)((6.2831854820251465 + angle - (double)pad) / (double)degPer) % segments : -1;
        if (angle < (double)pad) {
            angle = Math.PI * 2 + (double)pad;
        }
        this.slotSelected = -1;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        this.drawStacks.clear();
        for (int seg = 0; seg < segments; ++seg) {
            Pair<String, Block> pair = this.variants.get(seg);
            String variant = (String)pair.getFirst();
            Block variantBlock = (Block)pair.getSecond();
            boolean variantExists = variantBlock != null;
            boolean rightVariant = variant.equals(this.currentVariant);
            float start = (float)seg * degPer + pad;
            float end = (float)(seg + 1) * degPer + pad;
            boolean mouseInSector = variantExists && activeSegment == seg;
            float radius = Math.max(0.0f, Math.min((this.timeIn - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || rightVariant) {
                radius *= 1.1f;
            }
            if (!variantExists) {
                radius *= 0.9f;
            }
            int gs = 57;
            if (seg % 2 == 0) {
                gs += 41;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 68;
            if (variantExists) {
                g += 34;
                a = 153;
            } else {
                r /= 4;
                g /= 4;
                b /= 4;
            }
            if (seg == 0) {
                buf.addVertex((float)x, (float)y, 0.0f).setColor(r, g, b, a);
            }
            if (mouseInSector) {
                this.slotSelected = seg;
                r = 0;
                b = 170;
                g = 170;
            } else if (rightVariant) {
                b = 0;
                r = 0;
                g = 170;
            }
            float sxp = (float)x + Mth.cos((float)start) * radius;
            float syp = (float)y + Mth.sin((float)start) * radius;
            float exp = (float)x + Mth.cos((float)end) * radius;
            float eyp = (float)y + Mth.sin((float)end) * radius;
            buf.addVertex(sxp, syp, 0.0f).setColor(r, g, b, a);
            buf.addVertex(exp, eyp, 0.0f).setColor(r, g, b, a);
            float center = ((float)seg + 0.5f) * degPer + pad;
            float cxp = (float)x + Mth.cos((float)center) * radius;
            float cyp = (float)y + Mth.sin((float)center) * radius;
            ItemStack variantStack = variantExists ? new ItemStack((ItemLike)variantBlock) : ItemStack.EMPTY;
            double mod = 0.6;
            int xdp = (int)((double)(cxp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(cyp - (float)y) * mod + (double)y);
            this.drawStacks.add(new DrawStack(variantStack, xdp - 8, ydp - 8));
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        for (DrawStack ds : this.drawStacks) {
            if (ds.stack().isEmpty()) continue;
            guiGraphics.renderItem(ds.stack(), ds.x(), ds.y());
        }
        RenderSystem.disableBlend();
    }

    public void tick() {
        super.tick();
        if (!this.isKeyDown(this.key)) {
            this.mc.setScreen(null);
            if (this.slotSelected == -1 && this.timeIn < 10.0f) {
                this.slotSelected = 0;
            }
            if (this.slotSelected != -1) {
                String variant = (String)this.variants.get(this.slotSelected).getFirst();
                VariantSelectorModule.Client.setClientVariant(variant, true);
                this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.mc.options.keyUp, (Object)this.mc.options.keyLeft, (Object)this.mc.options.keyDown, (Object)this.mc.options.keyRight, (Object)this.mc.options.keyShift, (Object)this.mc.options.keySprint, (Object[])new KeyMapping[]{this.mc.options.keyJump});
        for (KeyMapping k : set) {
            KeyMapping.set((InputConstants.Key)k.getKey(), (boolean)this.isKeyDown(k));
        }
    }

    public boolean isKeyDown(KeyMapping keybind) {
        InputConstants.Key key = keybind.getKey();
        if (key.getType() == InputConstants.Type.MOUSE) {
            return keybind.isDown();
        }
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getValue());
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.atan2((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private record DrawStack(ItemStack stack, int x, int y) {
    }
}

