/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.addons.oddities.block.MagnetBlock;
import org.violetmoon.quark.addons.oddities.client.particle.MagnetParticleRenderType;

public class MagnetParticle
extends TextureSheetParticle {
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);
    private float xWobble = 0.0f;
    private float xWobbleO = 0.0f;
    private float yWobble = 0.0f;
    private float yWobbleO = 0.0f;
    private float alphaO = 0.0f;

    public MagnetParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.xd = pXSpeed;
        this.yd = pYSpeed;
        this.zd = pZSpeed;
        this.lifetime = 33;
        this.friction = 1.0f;
        this.setSize(0.01f, 0.01f);
        this.alpha = 0.0f;
        this.updateAlpha();
    }

    private void updateAlpha() {
        this.alphaO = this.alpha;
        int offset = 1;
        float t = (float)(this.age + offset) / (float)(this.lifetime + 1 + offset);
        this.setAlpha(0.6f * (1.0f - Mth.square((float)(2.0f * t - 1.0f))));
    }

    public float getQuadSize(float partialTicks) {
        float t = ((float)this.age + partialTicks) / (float)(this.lifetime + 1);
        return this.quadSize * (0.6f + (1.0f - Mth.square((float)(2.0f * t - 1.0f))) * 0.4f);
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.render(buffer, renderInfo, partialTicks);
    }

    public int getLightColor(float pPartialTick) {
        int i = super.getLightColor(pPartialTick);
        int k = i >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    public void tick() {
        super.tick();
        this.updateAlpha();
        float wobbleAmount = 0.12f;
        this.xWobbleO = this.xWobble;
        this.yWobbleO = this.yWobble;
        this.xWobble = this.random.nextFloat() * wobbleAmount;
        this.yWobble = this.random.nextFloat() * wobbleAmount;
    }

    public void move(double pX, double pY, double pZ) {
        Vec3 vec3;
        Vec3 moveDir;
        if (this.hasPhysics && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED && (moveDir = new Vec3(pX, pY, pZ)).distanceToSqr(vec3 = Entity.collideBoundingBox(null, (Vec3)moveDir, (AABB)this.getBoundingBox(), (Level)this.level, List.of())) > 1.0E-9 && !(this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).getBlock() instanceof MagnetBlock)) {
            this.remove();
            return;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = pY != pY && pY < 0.0;
        if (pX != pX) {
            this.xd = 0.0;
        }
        if (pZ != pZ) {
            this.zd = 0.0;
        }
    }

    public ParticleRenderType getRenderType() {
        return MagnetParticleRenderType.ADDITIVE_TRANSLUCENCY;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            MagnetParticle particle = new MagnetParticle(clientLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

