/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Shiba;

public class ShibaModel
extends EntityModel<Shiba> {
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart rEar;
    private final ModelPart lEar;
    private final ModelPart tongue;
    private final ModelPart torso;
    private final ModelPart tail;
    private final ModelPart rFrontLeg;
    private final ModelPart lFrontLeg;
    private final ModelPart rBackLeg;
    private final ModelPart lBackLeg;
    private boolean sleeping = false;

    public ShibaModel(ModelPart root) {
        this.main = root.getChild("main");
        this.head = this.main.getChild("head");
        this.rEar = this.head.getChild("rEar");
        this.lEar = this.head.getChild("lEar");
        this.tongue = this.head.getChild("tongue");
        this.torso = this.main.getChild("torso");
        this.tail = this.torso.getChild("tail");
        this.rFrontLeg = this.main.getChild("rFrontLeg");
        this.lFrontLeg = this.main.getChild("lFrontLeg");
        this.rBackLeg = this.main.getChild("rBackLeg");
        this.lBackLeg = this.main.getChild("lBackLeg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition main = root.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 11.0f, 6.0f, cubeDeformation).texOffs(44, 0).addBox(-1.5f, -6.0f, -8.0f, 3.0f, 3.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)15.0f, (float)-5.0f));
        head.addOrReplaceChild("rEar", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 2.0f, 3.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)-12.0f, (float)2.0f));
        head.addOrReplaceChild("lEar", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 2.0f, 3.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)-12.0f, (float)2.0f));
        head.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(36, 34).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)-8.0f));
        PartDefinition torso = main.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(36, 10).addBox(-3.0f, 0.0f, -4.0f, 6.0f, 14.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)13.0f, (float)-7.0f));
        torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, -3.0f, -3.0f, 4.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)14.0f, (float)4.0f));
        main.addOrReplaceChild("rFrontLeg", CubeListBuilder.create().texOffs(0, 21).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)16.0f, (float)-5.0f));
        main.addOrReplaceChild("lFrontLeg", CubeListBuilder.create().mirror().texOffs(0, 21).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)16.0f, (float)-5.0f));
        main.addOrReplaceChild("rBackLeg", CubeListBuilder.create().texOffs(12, 18).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)15.0f, (float)4.0f));
        main.addOrReplaceChild("lBackLeg", CubeListBuilder.create().mirror().texOffs(12, 18).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)15.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)80, (int)48);
    }

    public void transformToHead(PoseStack matrix) {
        this.head.translateAndRotate(matrix);
    }

    public void prepareMobModel(@NotNull Shiba shiba, float limbSwing, float limbSwingAmount, float partialTickTime) {
        BlockState state = shiba.getBlockStateOn();
        this.sleeping = state.is(BlockTags.BEDS);
        this.setRotationAngle(this.rFrontLeg, Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.lFrontLeg, Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.rBackLeg, Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.lBackLeg, Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
    }

    public void setupAnim(Shiba shiba, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch) {
        this.main.setPos(0.0f, 0.0f, 0.0f);
        this.lBackLeg.setPos(-3.0f, 15.0f, 4.0f);
        this.rBackLeg.setPos(3.0f, 15.0f, 4.0f);
        this.setRotationAngle(this.main, 0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.torso, 1.5708f, 0.0f, 0.0f);
        this.setRotationAngle(this.head, Mth.cos((float)(ageInTicks * 0.6f)) * 0.01f, yaw * ((float)Math.PI / 180), Mth.sin((float)(ageInTicks * 0.06f)) * 0.06f);
        this.setRotationAngle(this.tail, Mth.cos((float)(ageInTicks * 0.1f)) * 0.1f, Mth.sin((float)(ageInTicks * 0.15f)) * 0.12f, Mth.cos((float)(ageInTicks * 0.3f)) * 0.2f);
        this.setRotationAngle(this.lEar, 0.0f, Mth.cos((float)(ageInTicks * 0.08f)) * 0.05f - 0.05f, 0.0f);
        this.setRotationAngle(this.rEar, 0.0f, Mth.sin((float)(ageInTicks * 0.07f)) * 0.05f + 0.05f, 0.0f);
        boolean tongueOut = false;
        BlockState state = shiba.getBlockStateOn();
        boolean sleep = state.is(BlockTags.BEDS);
        if (shiba.isInSittingPose()) {
            tongueOut = true;
            if (sleep) {
                this.main.setPos(16.0f, 18.0f, 0.0f);
                this.setRotationAngle(this.main, 0.0f, 0.0f, 1.5708f);
                this.setRotationAngle(this.lBackLeg, Mth.cos((float)(ageInTicks * 0.2f)) * 0.1f, 0.0f, Mth.sin((float)(ageInTicks * 0.18f)) * 0.12f);
                this.setRotationAngle(this.rBackLeg, Mth.sin((float)(ageInTicks * 0.22f)) * 0.08f, 0.0f, Mth.cos((float)(ageInTicks * 0.16f)) * 0.11f);
                this.setRotationAngle(this.rFrontLeg, Mth.cos((float)(ageInTicks * 0.19f)) * 0.1f, 0.0f, Mth.sin((float)(ageInTicks * 0.21f)) * 0.12f);
                this.setRotationAngle(this.lFrontLeg, Mth.sin((float)(ageInTicks * 0.18f)) * 0.08f, 0.0f, Mth.cos((float)(ageInTicks * 0.2f)) * 0.11f);
            } else {
                this.setRotationAngle(this.torso, 1.0f, 0.0f, 0.0f);
                this.lBackLeg.setPos(-3.0f, 19.0f, 2.0f);
                this.rBackLeg.setPos(3.0f, 19.0f, 2.0f);
                this.setRotationAngle(this.lBackLeg, -1.0f, -0.5f, 0.0f);
                this.setRotationAngle(this.rBackLeg, -1.0f, -0.5f, 0.0f);
                this.setRotationAngle(this.lFrontLeg, -0.5f, 0.5f, 0.0f);
                this.setRotationAngle(this.rFrontLeg, -0.5f, 0.5f, 0.0f);
            }
        }
        if (tongueOut && shiba.getMouthItem().isEmpty()) {
            this.tongue.setPos(0.0f, -4.0f, -6.75f + Mth.cos((float)(ageInTicks * 0.19f)) * 0.25f);
            this.setRotationAngle(this.tongue, Mth.cos((float)(ageInTicks * 0.19f)) * 0.1f + 0.2f, 0.0f, 0.0f);
        } else {
            this.tongue.setPos(0.0f, -4.0f, -5.0f);
            this.setRotationAngle(this.tongue, 0.0f, 0.0f, 0.0f);
        }
    }

    public void renderToBuffer(PoseStack matrixStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        matrixStack.pushPose();
        if (this.sleeping) {
            matrixStack.translate(0.0, 0.12, 0.0);
        }
        this.main.translateAndRotate(matrixStack);
        matrixStack.pushPose();
        if (this.young) {
            matrixStack.translate(0.0f, 0.3125f, 0.0f);
        }
        this.head.render(matrixStack, buffer, packedLight, packedOverlay, color);
        matrixStack.popPose();
        matrixStack.pushPose();
        if (this.young) {
            matrixStack.translate(0.0f, 0.75f, 0.0f);
            matrixStack.scale(0.5f, 0.5f, 0.5f);
        }
        this.torso.render(matrixStack, buffer, packedLight, packedOverlay);
        this.rFrontLeg.render(matrixStack, buffer, packedLight, packedOverlay);
        this.rBackLeg.render(matrixStack, buffer, packedLight, packedOverlay);
        this.lFrontLeg.render(matrixStack, buffer, packedLight, packedOverlay);
        this.lBackLeg.render(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

