/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.living.ZLivingTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class VariantAnimalTexturesModule
extends ZetaModule {
    private static ListMultimap<VariantTextureType, ResourceLocation> textures;
    private static Map<VariantTextureType, ResourceLocation> shinyTextures;
    private static final int COW_COUNT = 4;
    private static final int PIG_COUNT = 3;
    private static final int CHICKEN_COUNT = 6;
    private static final int ALLAY_COUNT = 5;
    @Config
    public static boolean enableCow;
    @Config
    public static boolean enablePig;
    @Config
    public static boolean enableChicken;
    @Config
    public static boolean enableAllay;
    @Config
    public static boolean enableShinyRabbit;
    @Config
    public static boolean enableShinyLlama;
    @Config
    public static boolean enableShinyDolphin;
    @Config
    public static boolean enableShinySlime;
    @Config
    public static boolean enableShinyArmadillo;
    @Config
    public static boolean enableShinyFrog;
    @Config
    public static boolean enableLGBTBees;
    @Config
    public static boolean everyBeeIsLGBT;
    protected static final List<String> BEE_VARIANTS;
    @Config(description="The chance for an animal to have a special \"Shiny\" skin, like a shiny pokemon. This is 1 in X. Set to 0 to disable.")
    public static int shinyAnimalChance;
    @Config(description="If a shiny animal should emit occasional sparkles.")
    public static boolean shinySparkles;
    public static boolean staticEnabled;

    static {
        enableCow = true;
        enablePig = true;
        enableChicken = true;
        enableAllay = true;
        enableShinyRabbit = true;
        enableShinyLlama = true;
        enableShinyDolphin = true;
        enableShinySlime = true;
        enableShinyArmadillo = true;
        enableShinyFrog = true;
        enableLGBTBees = true;
        everyBeeIsLGBT = false;
        BEE_VARIANTS = List.of("acebee", "agenbee", "arobee", "beefluid", "beesexual", "beequeer", "enbee", "gaybee", "interbee", "lesbeean", "panbee", "polysexbee", "transbee", "helen", "mlbeem", "polyamorbee", "salmacibee");
        shinyAnimalChance = 2048;
        shinySparkles = true;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends VariantAnimalTexturesModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            textures = Multimaps.newListMultimap(new EnumMap(VariantTextureType.class), ArrayList::new);
            shinyTextures = new HashMap<VariantTextureType, ResourceLocation>();
            Client.registerTextures(VariantTextureType.COW, 4, ResourceLocation.withDefaultNamespace((String)"textures/entity/cow/cow.png"));
            Client.registerTextures(VariantTextureType.PIG, 3, ResourceLocation.withDefaultNamespace((String)"textures/entity/pig/pig.png"));
            Client.registerTextures(VariantTextureType.CHICKEN, 6, ResourceLocation.withDefaultNamespace((String)"textures/entity/chicken.png"));
            Client.registerTextures(VariantTextureType.ALLAY, 5, ResourceLocation.withDefaultNamespace((String)"textures/entity/allay/allay.png"));
            Client.registerShiny(VariantTextureType.RABBIT);
            Client.registerShiny(VariantTextureType.LLAMA);
            Client.registerShiny(VariantTextureType.DOLPHIN);
            Client.registerShiny(VariantTextureType.SLIME);
            Client.registerShiny(VariantTextureType.ARMADILLO);
            Client.registerShiny(VariantTextureType.FROG);
        }

        @LoadEvent
        public final void configChanged(ZConfigChanged event) {
            staticEnabled = this.isEnabled();
        }

        @PlayEvent
        public void doShinySparkles(ZLivingTick event) {
            if (!shinySparkles || !(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)event.getEntity();
            Level level = entity.level();
            if (level.isClientSide() && level.getGameTime() % 10L == 0L && Client.isSparkly((Entity)entity)) {
                double angle = Math.random() * 2.0 * Math.PI;
                double dist = Math.random() * 0.5 + 0.25;
                double dX = Math.cos(angle) * dist;
                double dY = (double)entity.getDimensions(entity.getPose()).height() + (Math.random() - 0.5) * 0.2;
                double dZ = Math.sin(angle) * dist;
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, entity.getX() + dX, entity.getY() + dY, entity.getZ() + dZ, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
            }
        }

        @Nullable
        public static ResourceLocation getCowTexture(Cow entity) {
            if (!staticEnabled || !enableCow) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.COW);
        }

        @Nullable
        public static ResourceLocation getPigTexture(Pig entity) {
            if (!staticEnabled || !enablePig) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.PIG);
        }

        @Nullable
        public static ResourceLocation getChickenTexture(Chicken entity) {
            if (!staticEnabled || !enableChicken) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.CHICKEN);
        }

        @Nullable
        public static ResourceLocation getAllayTexture(Allay entity) {
            if (!staticEnabled || !enableAllay) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.ALLAY);
        }

        @Nullable
        public static ResourceLocation getRabbitTexture(Rabbit entity) {
            if (!staticEnabled || !enableShinyRabbit) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.RABBIT, () -> null);
        }

        @Nullable
        public static ResourceLocation getLlamaTexture(Llama entity) {
            if (!staticEnabled || !enableShinyLlama) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.LLAMA, () -> null);
        }

        @Nullable
        public static ResourceLocation getDolphinTexture(Dolphin entity) {
            if (!staticEnabled || !enableShinyDolphin) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.DOLPHIN, () -> null);
        }

        @Nullable
        public static ResourceLocation getSlimeTexture(Slime entity) {
            if (!staticEnabled || !enableShinySlime) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.SLIME, () -> null);
        }

        @Nullable
        public static ResourceLocation getArmadilloTexture(Armadillo entity) {
            if (!staticEnabled || !enableShinyArmadillo) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.ARMADILLO, () -> null);
        }

        @Nullable
        public static ResourceLocation getFrogTexture(Frog entity) {
            if (!staticEnabled || !enableShinyFrog) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.FROG, () -> null);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public static ResourceLocation getBeeTexture(Bee entity) {
            if (!Client.staticEnabled || !Client.enableLGBTBees) {
                return null;
            }
            id = entity.getUUID();
            most = id.getMostSignificantBits();
            lgbtChance = 0.056;
            if (VariantAnimalTexturesModule.everyBeeIsLGBT) ** GOTO lbl-1000
            v0 = new Random(most);
            if (v0.nextDouble() < 0.056) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = lgbt = false;
            }
            if (entity.hasCustomName() || lgbt) {
                custName = "";
                if (entity.hasCustomName() && (name /* !! */  = entity.getCustomName()) != null) {
                    custName = name /* !! */ .getString();
                }
                if (!Client.BEE_VARIANTS.contains(name /* !! */  = custName.toLowerCase(Locale.ROOT))) {
                    if (custName.matches("wire(se|bee)gal")) {
                        name /* !! */  = "enbee";
                    } else if (lgbt) {
                        name /* !! */  = (String)Client.BEE_VARIANTS.get(Math.abs((int)(most % (long)(Client.BEE_VARIANTS.size() - 1))));
                    }
                }
                if (Client.BEE_VARIANTS.contains(name /* !! */ )) {
                    type = "normal";
                    angery = entity.hasStung();
                    nectar = entity.hasNectar();
                    if (angery) {
                        type = nectar != false ? "angry_nectar" : "angry";
                    } else if (nectar) {
                        type = "nectar";
                    }
                    path = String.format(Locale.ROOT, "textures/model/entity/variants/bees/%s/%s.png", new Object[]{name /* !! */ , type});
                    return Quark.asResource(path);
                }
            }
            return null;
        }

        public static boolean isShiny(UUID id) {
            long most = id.getMostSignificantBits();
            return shinyAnimalChance > 0 && most % (long)shinyAnimalChance == 0L;
        }

        public static boolean isSparkly(Entity e) {
            EntityType type = e.getType();
            if (!(type == EntityType.COW && enableCow || type == EntityType.PIG && enablePig || type == EntityType.CHICKEN && enableChicken || type == EntityType.RABBIT && enableShinyRabbit || type == EntityType.LLAMA && enableShinyLlama || type == EntityType.DOLPHIN && enableShinyDolphin || type == EntityType.ALLAY && enableAllay || type == EntityType.FROG && enableShinyFrog || type == EntityType.ARMADILLO && enableShinyArmadillo)) {
                return false;
            }
            return Client.isShiny(e.getUUID());
        }

        public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type) {
            return Client.getTextureOrShiny(e, type, () -> Client.getRandomTexture(e, type));
        }

        public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type, Supplier<ResourceLocation> nonShiny) {
            if (Client.isShiny(e.getUUID())) {
                return shinyTextures.get((Object)type);
            }
            return nonShiny.get();
        }

        private static ResourceLocation getRandomTexture(Entity e, VariantTextureType type) {
            List styles = textures.get((Object)type);
            UUID id = e.getUUID();
            long most = id.getMostSignificantBits();
            int choice = Math.abs((int)(most % (long)styles.size()));
            return (ResourceLocation)styles.get(choice);
        }

        private static void registerTextures(VariantTextureType type, int count, ResourceLocation vanilla) {
            String name = type.name().toLowerCase(Locale.ROOT);
            for (int i = 1; i < count + 1; ++i) {
                textures.put((Object)type, (Object)Quark.asResource(String.format(Locale.ROOT, "textures/model/entity/variants/%s%d.png", name, i)));
            }
            if (vanilla != null) {
                textures.put((Object)type, (Object)vanilla);
            }
            Client.registerShiny(type);
        }

        private static void registerShiny(VariantTextureType type) {
            shinyTextures.put(type, Quark.asResource(String.format(Locale.ROOT, "textures/model/entity/variants/%s_shiny.png", type.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static enum VariantTextureType {
        COW,
        PIG,
        CHICKEN,
        ALLAY,
        LLAMA,
        RABBIT,
        DOLPHIN,
        SLIME,
        ARMADILLO,
        FROG;

    }
}

