/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.inventory.slot;

import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CachedItemHandlerSlot
extends Slot {
    private ItemStack cached = ItemStack.EMPTY;
    private boolean caching = false;

    public CachedItemHandlerSlot(Container container, int index, int xPosition, int yPosition) {
        super(container, index, xPosition, yPosition);
    }

    @NotNull
    public ItemStack getItem() {
        if (this.caching) {
            return this.cached;
        }
        return super.getItem();
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.caching) {
            ItemStack newStack = this.cached.copy();
            int trueAmount = Math.min(amount, this.cached.getCount());
            this.cached.shrink(trueAmount);
            newStack.setCount(trueAmount);
            return newStack;
        }
        return super.remove(amount);
    }

    public void set(@NotNull ItemStack stack) {
        super.set(stack);
        if (this.caching) {
            this.cached = stack;
        }
    }

    public static void cache(AbstractContainerMenu container) {
        for (Slot slot : container.slots) {
            if (!(slot instanceof CachedItemHandlerSlot)) continue;
            CachedItemHandlerSlot thisSlot = (CachedItemHandlerSlot)slot;
            thisSlot.cached = slot.getItem();
            thisSlot.caching = true;
        }
    }

    public static void applyCache(AbstractContainerMenu container) {
        for (Slot slot : container.slots) {
            if (!(slot instanceof CachedItemHandlerSlot)) continue;
            CachedItemHandlerSlot thisSlot = (CachedItemHandlerSlot)slot;
            if (!thisSlot.caching) continue;
            slot.set(thisSlot.cached);
            thisSlot.caching = false;
        }
    }
}

