/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.ai.RaveGoal;
import org.violetmoon.quark.content.mobs.module.CrabsModule;

public class Crab
extends Animal
implements IEntityWithComplexSpawn,
Bucketable {
    public static final int COLORS = 3;
    public static final ResourceKey<LootTable> CRAB_LOOT_TABLE = Quark.asResourceKey(Registries.LOOT_TABLE, "entities/crab");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(Crab.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> RAVING = SynchedEntityData.defineId(Crab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(Crab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int lightningCooldown;
    private Ingredient temptationItems;
    private boolean noSpike;
    private BlockPos jukeboxPosition;
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener;

    public Crab(EntityType<? extends Crab> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        EntityPositionSource source = new EntityPositionSource((Entity)this, this.getEyeHeight());
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)source, ((GameEvent)GameEvent.JUKEBOX_PLAY.value()).notificationRadius()));
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    public void saveToBucketTag(@NotNull ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        stack.set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putInt("Variant", this.getVariant());
            tag.putBoolean("NoSpike", this.noSpike);
        });
    }

    public void loadFromBucketTag(@NotNull CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains("NoSpike")) {
            this.noSpike = tag.getBoolean("NoSpike");
        }
        this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)CrabsModule.crab_bucket);
    }

    @NotNull
    public SoundEvent getPickupSound() {
        return QuarkSounds.BUCKET_FILL_CRAB;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> acceptor) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            acceptor.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    public static boolean spawnPredicate(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(CrabsModule.crabSpawnableTag) && world.getMaxLocalRawBrightness(pos) > 8;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos.below()).is(CrabsModule.crabSpawnableTag) ? 10.0f : (float)world.getRawBrightness(pos, 0) - 0.5f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)-1);
        builder.define(RAVING, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getScale() >= 2.0f) {
            if (!(this.isFood(player.getItemInHand(hand)) || this.isVehicle() || player.isSecondaryUseActive())) {
                if (!this.level().isClientSide) {
                    player.startRiding((Entity)this);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        } else {
            Optional result = Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this);
            if (result.isPresent()) {
                return (InteractionResult)result.get();
            }
        }
        return super.mobInteract(player, hand);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity entity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() != Direction.Axis.Y) {
            float scale = this.getScale();
            int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos blockpos = this.blockPosition();
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (Pose pose : entity.getDismountPoses()) {
                AABB aabb = entity.getLocalBoundsForPose(pose);
                for (int[] aint1 : aint) {
                    mutPos.set((double)((float)blockpos.getX() + (float)aint1[0] * scale), (double)blockpos.getY(), (double)((float)blockpos.getZ() + (float)aint1[1] * scale));
                    double blockFloorHeight = this.level().getBlockFloorHeight((BlockPos)mutPos);
                    if (!DismountHelper.isBlockFloorValid((double)blockFloorHeight)) continue;
                    Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)mutPos, (double)blockFloorHeight);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)entity, (AABB)aabb.move(vec3))) continue;
                    entity.setPose(pose);
                    return vec3;
                }
            }
        }
        return super.getDismountLocationForPassenger(entity);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return QuarkSounds.ENTITY_CRAB_IDLE;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return QuarkSounds.ENTITY_CRAB_DIE;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return QuarkSounds.ENTITY_CRAB_HURT;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new RaveGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)this.getTemptationItems(), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 3.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && (Integer)this.entityData.get(VARIANT) == -1) {
            int variant = 0;
            if (this.random.nextBoolean()) {
                variant += this.random.nextInt(2) + 1;
            }
            if (this.random.nextInt(3) == 0) {
                variant += 3;
            }
            this.entityData.set(VARIANT, (Object)variant);
        }
        if (this.lightningCooldown > 0) {
            --this.lightningCooldown;
            this.clearFire();
        }
        if (this.isRaving() && this.level().isClientSide && this.tickCount % 10 == 0) {
            BlockPos below = this.blockPosition().below();
            BlockState belowState = this.level().getBlockState(below);
            if (belowState.is(BlockTags.SAND)) {
                this.level().levelEvent(2001, below, Block.getId((BlockState)belowState));
            }
        }
        if (this.isRaving() && !this.level().isClientSide && this.tickCount % 20 == 0 && this.shouldStopRaving()) {
            this.setRaving(false);
            this.jukeboxPosition = null;
        }
        if (!this.level().isClientSide) {
            this.recalculateStepHeight();
        }
    }

    public void recalculateStepHeight() {
        float baseStep = this.isInWater() ? 1.0f : 0.6f;
        AttributeInstance stepHeightAttribute = this.getAttribute(Attributes.STEP_HEIGHT);
        if (stepHeightAttribute != null) {
            stepHeightAttribute.removeModifier(Quark.asResource("step_height"));
            stepHeightAttribute.addPermanentModifier(new AttributeModifier(Quark.asResource("step_height"), Math.max(0.0, (double)baseStep + stepHeightAttribute.getValue()), AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        DamageSources sources = this.level().damageSources();
        return super.isInvulnerableTo(source) || source == sources.cactus() || source == sources.sweetBerryBush() || source == sources.lightningBolt() || this.getScale() > 1.0f && source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE);
    }

    public boolean fireImmune() {
        return super.fireImmune() || this.getScale() > 1.0f;
    }

    public void thunderHit(@NotNull ServerLevel sworld, @NotNull LightningBolt lightningBolt) {
        if (this.lightningCooldown > 0 || this.level().isClientSide) {
            return;
        }
        float sizeMod = this.getScale();
        if (sizeMod <= 15.0f) {
            AttributeInstance armorAttr;
            AttributeInstance speedAttr;
            AttributeInstance healthAttr = this.getAttribute(Attributes.MAX_HEALTH);
            if (healthAttr != null) {
                healthAttr.addPermanentModifier(new AttributeModifier(Quark.asResource("lightning_max_health_bonus_" + sizeMod), 0.5, AttributeModifier.Operation.ADD_VALUE));
            }
            if ((speedAttr = this.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
                speedAttr.addPermanentModifier(new AttributeModifier(Quark.asResource("lightning_speed_debuff_" + sizeMod), -0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((armorAttr = this.getAttribute(Attributes.ARMOR)) != null) {
                armorAttr.addPermanentModifier(new AttributeModifier(Quark.asResource("lightning_armor_bonus_" + sizeMod), 0.125, AttributeModifier.Operation.ADD_VALUE));
            }
            float scale = Math.min(sizeMod + 1.0f, 16.0f);
            AttributeInstance scaleAttr = this.getAttribute(Attributes.SCALE);
            if (scaleAttr != null) {
                scaleAttr.addOrReplacePermanentModifier(new AttributeModifier(Quark.asResource("lightning_size_increase"), (double)scale, AttributeModifier.Operation.ADD_VALUE));
            }
            this.refreshDimensions();
            this.lightningCooldown = 150;
        }
    }

    public void push(@NotNull Entity entityIn) {
        if (this.getScale() <= 1.0f) {
            super.push(entityIn);
        }
    }

    protected void doPush(@NotNull Entity entityIn) {
        super.doPush(entityIn);
        if (this.level().getDifficulty() != Difficulty.PEACEFUL && !this.noSpike && !this.hasPassenger(entityIn) && entityIn instanceof LivingEntity && !(entityIn instanceof Crab)) {
            entityIn.hurt(this.level().damageSources().cactus(), 1.0f);
        }
    }

    public boolean isFood(ItemStack stack) {
        return !stack.isEmpty() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.of(Quark.asTagKey(Registries.ITEM, "crab_tempt_items"));
        }
        return this.temptationItems;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel sworld, @NotNull AgeableMob other) {
        return new Crab(CrabsModule.crabType, this.level());
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return CRAB_LOOT_TABLE;
    }

    public int getVariant() {
        return Math.max(0, (Integer)this.entityData.get(VARIANT));
    }

    public void party(BlockPos pos, boolean isPartying) {
        if (isPartying) {
            if (!this.isRaving()) {
                this.jukeboxPosition = pos;
                this.setRaving(true);
            }
        } else if (pos.equals((Object)this.jukeboxPosition) || this.jukeboxPosition == null) {
            this.jukeboxPosition = null;
            this.setRaving(false);
        }
    }

    public boolean shouldStopRaving() {
        return this.jukeboxPosition == null || !this.jukeboxPosition.closerToCenterThan((Position)this.position(), (double)((GameEvent)GameEvent.JUKEBOX_PLAY.value()).notificationRadius()) || !this.level().getBlockState(this.jukeboxPosition).is(Blocks.JUKEBOX);
    }

    public boolean isRaving() {
        return (Boolean)this.entityData.get(RAVING);
    }

    public void setRaving(boolean raving) {
        this.entityData.set(RAVING, (Object)raving);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> parameter) {
        super.onSyncedDataUpdated(parameter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.lightningCooldown = compound.getInt("LightningCooldown");
        this.noSpike = compound.getBoolean("NoSpike");
        if (compound.contains("EnemyCrabRating")) {
            float sizeModifier = compound.getFloat("EnemyCrabRating");
            AttributeInstance scaleAttr = this.getAttribute(Attributes.SCALE);
            if (scaleAttr != null) {
                scaleAttr.addOrReplacePermanentModifier(new AttributeModifier(Quark.asResource("lightning_size_increase"), (double)sizeModifier, AttributeModifier.Operation.ADD_VALUE));
            }
            this.refreshDimensions();
        }
        if (compound.contains("Variant")) {
            this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        }
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LightningCooldown", this.lightningCooldown);
        compound.putInt("Variant", ((Integer)this.entityData.get(VARIANT)).intValue());
        compound.putBoolean("NoSpike", this.noSpike);
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf additionalData) {
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
    }

    public class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource source, int radius) {
            this.listenerSource = source;
            this.listenerRadius = radius;
        }

        @NotNull
        public PositionSource getListenerSource() {
            return this.listenerSource;
        }

        public int getListenerRadius() {
            return this.listenerRadius;
        }

        public boolean handleGameEvent(ServerLevel level, Holder<GameEvent> holder, GameEvent.Context context, Vec3 vec3) {
            if (holder == GameEvent.JUKEBOX_PLAY) {
                Crab.this.party(BlockPos.containing((Position)vec3), true);
                return true;
            }
            if (holder == GameEvent.JUKEBOX_STOP_PLAY) {
                Crab.this.party(BlockPos.containing((Position)vec3), false);
                return true;
            }
            return false;
        }
    }
}

