/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class SleepGoal
extends Goal {
    private final Foxhound foxhound;
    public boolean isSleeping;
    private boolean wasSitting;

    public SleepGoal(Foxhound foxhound) {
        this.foxhound = foxhound;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (!this.foxhound.isTame() || this.foxhound.isInWater() || !this.foxhound.onGround()) {
            return false;
        }
        LivingEntity living = this.foxhound.getOwner();
        if (living == null) {
            return true;
        }
        return !(this.foxhound.distanceToSqr((Entity)living) < 144.0 && living.getLastHurtByMob() != null || !this.isSleeping);
    }

    public boolean canContinueToUse() {
        return this.foxhound.getPose() == Pose.SLEEPING;
    }

    public void start() {
        this.foxhound.getNavigation().stop();
        this.wasSitting = this.foxhound.isOrderedToSit();
        this.foxhound.setOrderedToSit(true);
        this.foxhound.setInSittingPose(true);
    }

    public void stop() {
        this.foxhound.setOrderedToSit(this.wasSitting);
        this.foxhound.setInSittingPose(false);
        this.foxhound.clearSleepingPos();
    }

    public void setSleeping(boolean sleeping) {
        this.isSleeping = sleeping;
        this.foxhound.setPose(Pose.STANDING);
    }
}

