/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.world.module.FallenLogsModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.world.generator.Generator;

public class FallenLogGenerator
extends Generator {
    public FallenLogGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos corner) {
        int chance;
        int z;
        int x = corner.getX() + rand.nextInt(16);
        BlockPos center = new BlockPos(x, 128, z = corner.getZ() + rand.nextInt(16));
        Holder biome = this.getBiome((LevelAccessor)worldIn, center, false);
        int n = chance = biome.is(FallenLogsModule.reducedLogsTag) ? FallenLogsModule.sparseBiomeRarity : FallenLogsModule.rarity;
        if (rand.nextInt(chance) == 0) {
            BlockPos pos = worldIn.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR_WG, center);
            FallenLogGenerator.placeFallenLogAt((LevelAccessor)worldIn, pos);
        }
    }

    private static void placeFallenLogAt(LevelAccessor level, BlockPos pos) {
        FallenLogGenerator.placeFallenLogAt(level, pos, FallenLogGenerator.getLogBlockForPos(level, pos));
    }

    private static void placeFallenLogAt(LevelAccessor level, BlockPos pos, Block logBlock) {
        if (logBlock == Blocks.AIR) {
            return;
        }
        int attempts = 5;
        BlockState state = logBlock.defaultBlockState();
        RandomSource rand = level.getRandom();
        for (int attempt = 0; attempt < 5; ++attempt) {
            int dirOrd = rand.nextInt(MiscUtil.HORIZONTALS.length);
            Direction dir = MiscUtil.HORIZONTALS[dirOrd];
            state = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis());
            int len = 3 + rand.nextInt(2);
            if (!FallenLogGenerator.isPositionValid(level, pos, len, dir)) continue;
            FallenLogGenerator.createLog(level, pos, len, dir, state, rand, dirOrd);
            return;
        }
    }

    private static void createLog(LevelAccessor level, BlockPos pos, int len, Direction dir, BlockState state, RandomSource rand, int dirOrd) {
        List<Decor> decor = Decor.get(level, pos);
        for (int i = 0; i < len; ++i) {
            BlockPos abovePos;
            BlockState aboveState;
            BlockPos placePos = pos.relative(dir, i);
            level.setBlock(placePos, state, 3);
            if (rand.nextInt(10) < 7 && decor.contains((Object)Decor.MOSS_CARPET) && (aboveState = level.getBlockState(abovePos = placePos.above())).isAir()) {
                level.setBlock(abovePos, Blocks.MOSS_CARPET.defaultBlockState(), 3);
            }
            Direction[][] sideDirections = new Direction[][]{{Direction.EAST, Direction.WEST}, {Direction.EAST, Direction.WEST}, {Direction.NORTH, Direction.SOUTH}, {Direction.NORTH, Direction.SOUTH}};
            for (int j = 0; j < 2; ++j) {
                if (rand.nextInt(5) >= 3) continue;
                Direction side = sideDirections[dirOrd][j];
                BlockPos sidePos = placePos.relative(side);
                FallenLogGenerator.placeDecorIfPossible(level, rand, side, sidePos, decor);
            }
            if (rand.nextInt(10) < 4) {
                FallenLogGenerator.placeDecorIfPossible(level, rand, dir, pos.relative(dir.getOpposite()), decor);
            }
            if (rand.nextInt(10) >= 4) continue;
            FallenLogGenerator.placeDecorIfPossible(level, rand, dir.getOpposite(), pos.relative(dir, len), decor);
        }
    }

    private static boolean isPositionValid(LevelAccessor level, BlockPos pos, int len, Direction dir) {
        boolean canSpawnOnWater = (double)level.getRandom().nextFloat() < FallenLogsModule.onWaterChance;
        for (int i = 0; i < len; ++i) {
            BlockPos testPos = pos.relative(dir, i);
            BlockState testState = level.getBlockState(testPos);
            if (!(testState.isAir() || testState.canBeReplaced() || testState.is(BlockTags.FLOWERS))) {
                return false;
            }
            BlockPos belowPos = testPos.below();
            BlockState belowState = level.getBlockState(belowPos);
            if (canSpawnOnWater && belowState.is(Blocks.WATER) || belowState.is(FallenLogsModule.canSpawnOnTag)) continue;
            return false;
        }
        return true;
    }

    private static void placeDecorIfPossible(LevelAccessor level, RandomSource rand, Direction side, BlockPos sidePos, List<Decor> decor) {
        if (decor.isEmpty()) {
            return;
        }
        BlockState sideState = level.getBlockState(sidePos);
        if (sideState.isAir()) {
            BlockState placeState;
            Decor selected = decor.get(rand.nextInt(decor.size()));
            switch (selected.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BlockState blockState = Blocks.MOSS_CARPET.defaultBlockState();
                    break;
                }
                case 1: {
                    BlockState blockState = (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)side.getOpposite()), (Comparable)Boolean.valueOf(true));
                    break;
                }
                case 2: {
                    BlockState blockState = placeState = Blocks.FERN.defaultBlockState();
                }
            }
            if (placeState.canSurvive((LevelReader)level, sidePos) && (selected != Decor.MOSS_CARPET || level.getBlockState(sidePos.below()).isSolid())) {
                level.setBlock(sidePos, placeState, 3);
            }
        }
    }

    private static Block getLogBlockForPos(LevelAccessor level, BlockPos pos) {
        Block hollow;
        Block base = FallenLogGenerator.getBaseLogBlockForPos(level, pos);
        if (HollowLogsModule.staticEnabled && (double)level.getRandom().nextFloat() < FallenLogsModule.hollowChance && (hollow = HollowLogsModule.logMap.get(base)) != null) {
            return hollow;
        }
        return base;
    }

    private static Block getBaseLogBlockForPos(LevelAccessor level, BlockPos pos) {
        Holder biome = level.getBiome(pos);
        ArrayList<Block> matched = new ArrayList<Block>();
        for (Map.Entry<TagKey<Biome>, Block> e : FallenLogsModule.blocksPerTag.entrySet()) {
            if (!biome.is(e.getKey())) continue;
            matched.add(e.getValue());
        }
        if (matched.isEmpty()) {
            return Blocks.AIR;
        }
        return (Block)matched.get(level.getRandom().nextInt(matched.size()));
    }

    private static enum Decor {
        MOSS_CARPET,
        VINE,
        FERN;


        public static List<Decor> get(LevelAccessor level, BlockPos pos) {
            Holder b = level.getBiome(pos);
            Biome biome = (Biome)b.value();
            ArrayList<Decor> list = new ArrayList<Decor>();
            Biome.ClimateSettings climateSettings = biome.getModifiedClimateSettings();
            double temperature = Mth.clamp((float)climateSettings.temperature(), (float)0.0f, (float)1.0f);
            double humidify = Mth.clamp((float)climateSettings.downfall(), (float)0.0f, (float)1.0f);
            humidify *= temperature;
            if (temperature < 0.3) {
                list.add(FERN);
            }
            if (humidify > 0.5) {
                list.add(MOSS_CARPET);
            }
            if (humidify > 0.75) {
                list.add(VINE);
            }
            return list.stream().toList();
        }
    }
}

