/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.resources.language.I18n;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class BackButtonKeybindModule
extends ZetaModule {

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends BackButtonKeybindModule {
        private KeyMapping backKey;
        private List<GuiEventListener> listeners;
        private InputConstants.Key lastKey;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.backKey = event.initMouse("quark.keybind.back", 4, "quark.gui.keygroup.misc", key -> key.getType() != InputConstants.Type.MOUSE || key.getValue() != 0);
        }

        @PlayEvent
        public void openGui(ZScreen.Init.Pre event) {
            this.lastKey = this.backKey.getKey();
            this.listeners = event.getListenersList();
        }

        @PlayEvent
        public void onKeyInput(ZScreen.KeyPressed.Post event) {
            if (this.backKey.getKey().getType() == InputConstants.Type.KEYSYM && event.getKeyCode() == this.backKey.getKey().getValue()) {
                this.clicc();
            }
        }

        @PlayEvent
        public void onMouseInput(ZScreen.MouseButtonPressed.Post event) {
            if (this.keybindsScreenHack((ZScreen)event)) {
                return;
            }
            int btn = event.getButton();
            if (this.backKey.getKey().getType() == InputConstants.Type.MOUSE && btn != 0 && btn == this.backKey.getKey().getValue()) {
                this.clicc();
            }
        }

        private boolean keybindsScreenHack(ZScreen evt) {
            if (!(evt.getScreen() instanceof KeyBindsScreen)) {
                return false;
            }
            boolean different = !Objects.equals(this.lastKey, this.backKey.getKey());
            this.lastKey = this.backKey.getKey();
            return different;
        }

        private void clicc() {
            ImmutableSet buttons = ImmutableSet.of((Object)I18n.get((String)"gui.back", (Object[])new Object[0]), (Object)I18n.get((String)"gui.done", (Object[])new Object[0]), (Object)I18n.get((String)"gui.cancel", (Object[])new Object[0]), (Object)I18n.get((String)"gui.toTitle", (Object[])new Object[0]), (Object)I18n.get((String)"gui.toMenu", (Object[])new Object[0]), (Object)I18n.get((String)"quark.gui.config.save", (Object[])new Object[0]), (Object[])new String[0]);
            for (String b : buttons) {
                for (GuiEventListener listener : this.listeners) {
                    Button w;
                    if (!(listener instanceof Button) || !(w = (Button)listener).getMessage().getString().equals(b) || !w.visible || !w.active) continue;
                    w.onClick(0.0, 0.0);
                    return;
                }
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && mc.screen != null) {
                mc.screen.onClose();
            }
        }
    }
}

