/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.client.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.experimental.module.VariantSelectorModule;

public class VariantsComponent
implements ClientTooltipComponent,
TooltipComponent {
    final ItemStack stack;
    boolean computed = false;
    List<ItemStack> variants;
    int height;
    int width;

    public VariantsComponent(ItemStack stack) {
        this.stack = stack;
    }

    private List<ItemStack> getVariants() {
        if (this.computed) {
            return this.variants;
        }
        ArrayList<ItemStack> setVariants = new ArrayList<ItemStack>();
        Item item = this.stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            Block block = bi.getBlock();
            Collection<Block> allVariants = VariantSelectorModule.variants.getAllVariants(block);
            for (Block b : allVariants) {
                setVariants.add(new ItemStack((ItemLike)b));
            }
        }
        this.computed = true;
        this.variants = setVariants;
        int size = this.variants.size();
        this.height = size == 0 ? 0 : 20;
        this.width = size * 18 - 2;
        return this.variants;
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        List<ItemStack> variants = this.getVariants();
        for (int i = 0; i < variants.size(); ++i) {
            ItemStack variant = variants.get(i);
            guiGraphics.renderItem(variant, x + i * 18, y);
        }
    }

    public int getHeight() {
        this.getVariants();
        return this.height;
    }

    public int getWidth(@NotNull Font font) {
        this.getVariants();
        return this.width;
    }
}

