/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.module.DyeableItemFramesModule;

public class DyedItemFrame
extends ItemFrame {
    private static final String TAG_COLOR = "q_color";
    private static final String TAG_GLOW = "q_glow";
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(DyedItemFrame.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_GLOW = SynchedEntityData.defineId(DyedItemFrame.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DyedItemFrame(EntityType<? extends DyedItemFrame> p_149607_, Level p_149608_) {
        super(p_149607_, p_149608_);
    }

    public DyedItemFrame(Level level, BlockPos pos, Direction direction, int color, boolean glow) {
        super(DyeableItemFramesModule.entityType, level, pos, direction);
        this.getEntityData().set(DATA_COLOR, (Object)color);
        this.getEntityData().set(DATA_GLOW, (Object)glow);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLOR, (Object)0);
        builder.define(DATA_GLOW, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putInt(TAG_COLOR, this.getColor().intValue());
        cmp.putBoolean(TAG_GLOW, this.isGlow());
    }

    public void readAdditionalSaveData(CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.getEntityData().set(DATA_COLOR, (Object)cmp.getInt(TAG_COLOR));
        this.getEntityData().set(DATA_GLOW, (Object)cmp.getBoolean(TAG_GLOW));
    }

    public Integer getColor() {
        return (Integer)this.getEntityData().get(DATA_COLOR);
    }

    public boolean isGlow() {
        return (Boolean)this.getEntityData().get(DATA_GLOW);
    }

    public SoundEvent getRemoveItemSound() {
        return this.isGlow() ? SoundEvents.GLOW_ITEM_FRAME_REMOVE_ITEM : super.getRemoveItemSound();
    }

    public SoundEvent getBreakSound() {
        return this.isGlow() ? SoundEvents.GLOW_ITEM_FRAME_BREAK : super.getRemoveItemSound();
    }

    public SoundEvent getPlaceSound() {
        return this.isGlow() ? SoundEvents.GLOW_ITEM_FRAME_PLACE : super.getRemoveItemSound();
    }

    public SoundEvent getAddItemSound() {
        return this.isGlow() ? SoundEvents.GLOW_ITEM_FRAME_ADD_ITEM : super.getRemoveItemSound();
    }

    public SoundEvent getRotateItemSound() {
        return this.isGlow() ? SoundEvents.GLOW_ITEM_FRAME_ROTATE_ITEM : super.getRemoveItemSound();
    }

    protected ItemStack getFrameItemStack() {
        ItemStack stack = new ItemStack((ItemLike)(this.isGlow() ? Items.GLOW_ITEM_FRAME : Items.ITEM_FRAME));
        Quark.ZETA.dyeables.applyDye(stack, new DyedItemColor(this.getColor().intValue(), false));
        return stack;
    }
}

