/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.inventory.CrateMenu;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.api.IQuarkButtonAllowed;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.client.handler.InventoryButtonHandler;
import org.violetmoon.quark.content.client.module.ChestSearchingModule;

public class CrateScreen
extends AbstractContainerScreen<CrateMenu>
implements IQuarkButtonAllowed {
    private static final ResourceLocation TEXTURE = Quark.asResource("textures/gui/crate.png");
    private int lastScroll;
    private int scrollOffs;
    private boolean scrolling;
    private List<Rect2i> extraAreas;

    public CrateScreen(CrateMenu container, Inventory inv, Component component) {
        super((AbstractContainerMenu)container, inv, component);
        int inventoryRows = 6;
        this.imageHeight = 114 + inventoryRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.extraAreas = Lists.newArrayList((Object[])new Rect2i[]{new Rect2i(i + this.imageWidth, j, 23, 136)});
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private boolean canScroll() {
        return ((CrateMenu)this.menu).getStackCount() / 9 > 0;
    }

    private float getPxPerScroll() {
        return 95.0f / ((float)((CrateMenu)this.menu).getStackCount() / 9.0f);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        ((CrateMenu)this.menu).scroll(scrollY < 0.0, true);
        this.lastScroll = this.scrollOffs = Math.round((float)((CrateMenu)this.menu).scroll / 9.0f * this.getPxPerScroll());
        return true;
    }

    public boolean mouseClicked(double p_98531_, double p_98532_, int p_98533_) {
        if (p_98533_ == 0 && this.insideScrollbar(p_98531_, p_98532_)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.mouseClicked(p_98531_, p_98532_, p_98533_);
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int left = this.leftPos + 175;
        int top = this.topPos + 18;
        int right = left + 14;
        int bottom = top + 112;
        return mouseX >= (double)left && mouseY >= (double)top && mouseX < (double)right && mouseY < (double)bottom;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int p_98537_, double p_98538_, double p_98539_) {
        if (this.scrolling) {
            int top = this.topPos + 18;
            double relative = mouseY - (double)top - 6.0;
            if (relative < 0.0) {
                relative = 0.0;
            } else if (relative > 95.0) {
                relative = 95.0;
            }
            this.scrollOffs = (int)relative;
            float diff = this.scrollOffs - this.lastScroll;
            float pixelsNeeded = this.getPxPerScroll();
            while (Math.abs(diff) >= pixelsNeeded) {
                boolean up = diff > 0.0f;
                ((CrateMenu)this.menu).scroll(up, true);
                this.lastScroll = Math.round((float)((CrateMenu)this.menu).scroll / 9.0f * pixelsNeeded);
                diff = this.scrollOffs - this.lastScroll;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, p_98537_, p_98538_, p_98539_);
    }

    public boolean mouseReleased(double p_98622_, double p_98623_, int p_98624_) {
        if (p_98624_ == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(p_98622_, p_98623_, p_98624_);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, i, j, 0, 0, this.imageWidth + 20, this.imageHeight);
        int maxScroll = ((CrateMenu)this.menu).getStackCount() / 9 * 9;
        int u = 232 + (maxScroll == 0 ? 12 : 0);
        int by = j + 18 + this.scrollOffs;
        guiGraphics.blit(TEXTURE, i + this.imageWidth, by, u, 0, 12, 15);
        if (!((ChestSearchingModule)Quark.ZETA.modules.get(ChestSearchingModule.class)).searchBarShown()) {
            String s = ((CrateMenu)this.menu).getTotal() + "/" + CrateModule.maxItems;
            int color = ClientUtil.getGuiTextColor("crate_count");
            guiGraphics.drawString(this.font, s, i + this.imageWidth - this.font.width(s) - 8 - InventoryButtonHandler.getActiveButtons(InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY).size() * 12, j + 6, color, false);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int color = ClientUtil.getGuiTextColor("crate_count");
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, color, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, color, false);
    }
}

