/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.MovingMagnetizedBlock;
import org.violetmoon.quark.addons.oddities.block.be.MagnetBlockEntity;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.zeta.api.ICollateralMover;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class MagnetBlock
extends ZetaBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WAXED = BooleanProperty.create((String)"waxed");

    public MagnetBlock(@Nullable ZetaModule module) {
        super("magnet", module, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).hasPostProcess(MagnetBlock::isPowered).lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 3 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.REDSTONE_BLOCKS);
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (stack.getHoverName().getString().equals("Q")) {
            components.add((Component)Component.literal((String)"haha yes"));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, WAXED});
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean wasPowered = (Boolean)state.getValue((Property)POWERED);
        boolean isPowered = this.hasPower(worldIn, pos, (Direction)state.getValue((Property)FACING));
        if (isPowered != wasPowered) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int action, int data) {
        boolean push = action == 0;
        Direction moveDir = (Direction)state.getValue((Property)FACING);
        Direction dir = push ? moveDir : moveDir.getOpposite();
        BlockPos targetPos = pos.relative(dir, data);
        BlockState targetState = world.getBlockState(targetPos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof MagnetBlockEntity)) {
            return false;
        }
        MagnetBlockEntity be = (MagnetBlockEntity)blockEntity;
        BlockPos endPos = targetPos.relative(moveDir);
        ICollateralMover.MoveResult reaction = MagnetSystem.getPushAction(be, targetPos, targetState, moveDir);
        if (reaction != ICollateralMover.MoveResult.MOVE && reaction != ICollateralMover.MoveResult.BREAK) {
            return false;
        }
        BlockEntity tilePresent = world.getBlockEntity(targetPos);
        CompoundTag tileData = new CompoundTag();
        if (tilePresent != null && !(tilePresent instanceof MagnetizedBlockBlockEntity)) {
            tileData = tilePresent.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            tilePresent.setRemoved();
        }
        BlockState setState = (BlockState)MagnetsModule.magnetized_block.defaultBlockState().setValue((Property)MovingMagnetizedBlock.FACING, (Comparable)moveDir);
        MagnetizedBlockBlockEntity movingTile = new MagnetizedBlockBlockEntity(endPos, setState, targetState, tileData, moveDir);
        if (!world.isClientSide && reaction == ICollateralMover.MoveResult.BREAK) {
            world.destroyBlock(endPos, true);
        }
        world.setBlock(endPos, setState, 68);
        world.setBlockEntity((BlockEntity)movingTile);
        world.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 67);
        return true;
    }

    private static boolean isPowered(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    private boolean hasPower(Level worldIn, BlockPos pos, Direction facing) {
        return worldIn.hasNeighborSignal(pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(this.hasPower(context.getLevel(), context.getClickedPos(), facing)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MagnetBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return MagnetBlock.createTickerHelper(type, MagnetsModule.magnetType, MagnetBlockEntity::tick);
    }
}

