/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.violetmoon.quark.base.QuarkClient;

public class ElytraDuplicationExtension<R extends CraftingRecipe>
implements ICraftingCategoryExtension<R> {
    public void setRecipe(RecipeHolder<R> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        ArrayList<List<ItemStack>> inputLists = new ArrayList<List<ItemStack>>();
        for (Ingredient input : ((CraftingRecipe)recipeHolder.value()).getIngredients()) {
            ItemStack[] stacks = input.getItems();
            List<ItemStack> expandedInput = List.of(stacks);
            inputLists.add(expandedInput);
        }
        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputLists, 0, 0);
        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, (List)Lists.newArrayList((Object[])new ItemStack[]{((CraftingRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)QuarkClient.ZETA_CLIENT.hackilyGetCurrentClientLevelRegistryAccess())}));
    }

    public void drawInfo(RecipeHolder<R> recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.drawString(Minecraft.getInstance().font, I18n.get((String)"quark.jei.makes_copy", (Object[])new Object[0]), 60, 46, 0x555555);
    }
}

