/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.violetmoon.quark.addons.oddities.block.be.PipeBlockEntity;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.quark.content.automation.block.ChuteBlock;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public class ChuteBlockEntity
extends ZetaBlockEntity
implements Container {
    private static final AABB CLEARANCE = new AABB(BlockPos.ZERO).deflate(0.25).move(0.0, 0.25, 0.0);

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super(ChuteModule.blockEntityType, pos, state);
    }

    private boolean canDropItem() {
        if (this.level != null && ((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ChuteBlock.ENABLED)).booleanValue()) {
            BlockPos below = this.worldPosition.below();
            BlockState state = this.level.getBlockState(below);
            if (state.isAir()) {
                return true;
            }
            if (state.is(GrateModule.grate)) {
                return true;
            }
            if (state.is(PipesModule.pipesTag) && state.hasProperty((Property)PipeBlock.UP)) {
                return true;
            }
            VoxelShape shape = state.getCollisionShape((BlockGetter)this.level, below);
            if (shape.isEmpty()) {
                return true;
            }
            if (shape.max(Direction.Axis.Y) > 1.0) {
                return false;
            }
            for (AABB box : shape.toAabbs()) {
                if (!box.intersects(CLEARANCE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int slot) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.canDropItem()) {
            return;
        }
        if (this.level != null && !stack.isEmpty()) {
            BlockPos below = this.worldPosition.below();
            BlockState state = this.level.getBlockState(below);
            if (state.is(PipesModule.pipesTag) && state.hasProperty((Property)PipeBlock.UP)) {
                ((PipeBlockEntity)this.level.getBlockEntity(below)).passIn(stack, Direction.UP);
            } else {
                ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() - 0.5, (double)this.worldPosition.getZ() + 0.5, stack.copy());
                entity.setDeltaMovement(0.0, 0.0, 0.0);
                this.level.addFreshEntity((Entity)entity);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return super.canPlaceItem(slot, stack) && this.canDropItem();
    }

    public void clearContent() {
    }
}

