/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.ai.RunAwayFromPikesGoal;
import org.violetmoon.quark.content.tools.client.render.entity.SkullPikeRenderer;
import org.violetmoon.quark.content.tools.entity.SkullPike;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tools")
public class SkullPikesModule
extends ZetaModule {
    public static EntityType<SkullPike> skullPikeType;
    @Hint(key="skull_pikes")
    public static TagKey<Block> pikeTrophiesTag;
    @Config
    public static double pikeRange;

    @LoadEvent
    public final void register(ZRegister event) {
        skullPikeType = EntityType.Builder.of(SkullPike::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(3).updateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).build("skull_pike");
        Quark.ZETA.registry.register(skullPikeType, "skull_pike", Registries.ENTITY_TYPE);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        pikeTrophiesTag = Quark.asTagKey(Registries.BLOCK, "pike_trophies");
    }

    @PlayEvent
    public void onPlaceBlock(ZBlock.EntityPlace event) {
        BlockPos pos;
        BlockPos down;
        Level world;
        BlockState downState;
        LevelAccessor iworld;
        BlockState state = event.getPlacedBlock();
        if (state.is(pikeTrophiesTag) && (iworld = event.getLevel()) instanceof Level && (downState = (world = (Level)iworld).getBlockState(down = (pos = event.getPos()).below())).is(BlockTags.FENCES)) {
            SkullPike pike = new SkullPike(skullPikeType, world);
            pike.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            world.addFreshEntity((Entity)pike);
        }
    }

    @PlayEvent
    public void onMonsterAppear(ZEntityJoinLevel event) {
        Entity entity = event.getEntity();
        if (entity instanceof Monster) {
            boolean alreadySetUp;
            Monster monster = (Monster)entity;
            if (!(entity instanceof PatrollingMonster) && !(entity instanceof Warden) && entity.canUsePortal(false) && !(alreadySetUp = monster.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.getGoal() instanceof RunAwayFromPikesGoal))) {
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)monster.goalSelector, (int)3, (Goal)new RunAwayFromPikesGoal((PathfinderMob)monster, (float)pikeRange, 1.0, 1.2));
            }
        }
    }

    static {
        pikeRange = 5.0;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends SkullPikesModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.register((EntityType)skullPikeType, SkullPikeRenderer::new);
        }
    }
}

