/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Stoneling;

public class StonelingModel
extends EntityModel<Stoneling> {
    private final ModelPart body;
    private final ModelPart arm_right;
    private final ModelPart arm_left;
    private final ModelPart leg_right;
    private final ModelPart leg_left;

    public StonelingModel(ModelPart root) {
        this.body = root.getChild("body");
        this.arm_right = root.getChild("arm_right");
        this.arm_left = root.getChild("arm_left");
        this.leg_right = root.getChild("leg_right");
        this.leg_left = root.getChild("leg_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -9.0f, -3.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(36, 13).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 7).addBox(-4.0f, -9.0f, -5.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-2.0f, -12.0f, -1.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 7).addBox(-2.0f, -9.0f, -6.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(25, 24).addBox(-2.0f, -12.0f, -5.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(36, 17).addBox(-2.0f, -11.0f, 3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        body.addOrReplaceChild("lychen", CubeListBuilder.create().texOffs(10, 12).addBox(0.0f, -4.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(10, 16).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-9.0f, (float)3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body.addOrReplaceChild("dripstone", CubeListBuilder.create().texOffs(14, 16).addBox(0.0f, -5.0f, -3.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(14, 22).addBox(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(27, 13).addBox(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.25f, (float)19.0f, (float)0.5f));
        root.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(27, 13).mirror().addBox(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.25f, (float)19.0f, (float)0.5f));
        root.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)15.0f, (float)0.5f));
        root.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(0.0f, 0.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)15.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Stoneling stoneling, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg_right.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg_left.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        ItemStack carry = stoneling.getCarryingItem();
        if (carry.isEmpty() && !stoneling.isVehicle()) {
            this.arm_right.xRot = 0.0f;
            this.arm_left.xRot = 0.0f;
        } else {
            this.arm_right.xRot = 3.1416f;
            this.arm_left.xRot = 3.1416f;
        }
    }

    public void renderToBuffer(@NotNull PoseStack matrix, @NotNull VertexConsumer vb, int packedLightIn, int packedOverlayIn, int color) {
        this.body.render(matrix, vb, packedLightIn, packedOverlayIn, color);
        this.arm_right.render(matrix, vb, packedLightIn, packedOverlayIn, color);
        this.arm_left.render(matrix, vb, packedLightIn, packedOverlayIn, color);
        this.leg_right.render(matrix, vb, packedLightIn, packedOverlayIn, color);
        this.leg_left.render(matrix, vb, packedLightIn, packedOverlayIn, color);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

