/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.block.be.FeedingTroughBlockEntity;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class FeedingTroughBlock
extends ZetaBlock
implements EntityBlock {
    private static final SoundType WOOD_WITH_PLANT_STEP = new DeferredSoundType(1.0f, 1.0f, () -> SoundEvents.WOOD_BREAK, () -> SoundEvents.GRASS_STEP, () -> SoundEvents.WOOD_PLACE, () -> SoundEvents.WOOD_HIT, () -> SoundEvents.WOOD_FALL);
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    public static final VoxelShape CUBOID_SHAPE = FeedingTroughBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EMPTY_SHAPE = Shapes.join((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final VoxelShape FULL_SHAPE = Shapes.join((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final VoxelShape ANIMAL_SHAPE = FeedingTroughBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public FeedingTroughBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.COMPOSTER, true);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Entity entity;
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ecc = (EntityCollisionContext)context;
            v0 = ecc.getEntity();
        } else {
            v0 = entity = null;
        }
        if (entity instanceof Animal) {
            return ANIMAL_SHAPE;
        }
        return EMPTY_SHAPE;
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return CUBOID_SHAPE;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)FULL) != false ? FULL_SHAPE : EMPTY_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FULL});
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            return WOOD_WITH_PLANT_STEP;
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public void fallOn(Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float distance) {
        if (((Boolean)level.getBlockState(pos).getValue((Property)FULL)).booleanValue()) {
            entity.causeFallDamage(distance, 0.2f, level.damageSources().fall());
        } else {
            super.fallOn(level, state, pos, entity, distance);
        }
    }

    public void onRemove(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity f = (FeedingTroughBlockEntity)tile;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)f);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult trace) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = this.getMenuProvider(state, world, pos);
        if (container != null) {
            player.openMenu(container);
        }
        return InteractionResult.CONSUME;
    }

    public boolean triggerEvent(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int id, int param) {
        super.triggerEvent(state, world, pos, id, param);
        BlockEntity tile = world.getBlockEntity(pos);
        return tile != null && tile.triggerEvent(id, param);
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        MenuProvider m;
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof MenuProvider ? (m = (MenuProvider)tile) : null;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FeedingTroughBlockEntity(pos, state);
    }
}

