/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.world.module.ChorusVegetationModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class ChorusVegetationBlock
extends ZetaBlock
implements BonemealableBlock,
IShearable {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final boolean simple;

    public ChorusVegetationBlock(String regname, @Nullable ZetaModule module, boolean simple) {
        super(regname, module, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).randomTicks().ignitedByLava().pushReaction(PushReaction.DESTROY));
        this.simple = simple;
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.NATURAL_BLOCKS, (ItemLike)Blocks.CHORUS_PLANT, true);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextDouble() < ChorusVegetationModule.passiveTeleportChance) {
            this.teleport(pos, random, worldIn, state);
        }
    }

    public void animateTick(@NotNull BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.2 + rand.nextDouble() * 0.6, (double)pos.getY() + 0.3, (double)pos.getZ() + 0.2 + rand.nextDouble() * 0.6, 0.0, 0.0, 0.0);
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (this.simple && worldIn instanceof ServerLevel) {
            BlockPos target;
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (entity instanceof LivingEntity && !(entity instanceof EnderMan) && !(entity instanceof Endermite) && (target = this.teleport(pos, worldIn.random, serverLevel, state)) != null && worldIn.random.nextDouble() < ChorusVegetationModule.endermiteSpawnChance) {
                Endermite mite = new Endermite(EntityType.ENDERMITE, worldIn);
                mite.setPos((double)target.getX(), (double)target.getY(), (double)target.getZ());
                worldIn.addFreshEntity((Entity)mite);
            }
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            this.runAwayFromWater(pos, worldIn.random, serverLevel, state);
        }
    }

    private void runAwayFromWater(BlockPos pos, RandomSource random, ServerLevel worldIn, BlockState state) {
        for (Direction d : Direction.values()) {
            BlockPos test = pos.relative(d);
            FluidState fluid = worldIn.getFluidState(test);
            if (fluid.getType() != Fluids.WATER && fluid.getType() != Fluids.FLOWING_WATER) continue;
            this.teleport(pos, random, worldIn, state, 8, 1.0);
            return;
        }
    }

    private BlockPos teleport(BlockPos pos, RandomSource random, ServerLevel worldIn, BlockState state) {
        return this.teleport(pos, random, worldIn, state, 4, 1.0 - ChorusVegetationModule.teleportDuplicationChance);
    }

    private BlockPos teleport(BlockPos pos, RandomSource random, ServerLevel worldIn, BlockState state, int range, double growthChance) {
        BlockState stateAt;
        int zOff;
        int xOff;
        do {
            xOff = random.nextInt(range + 1) - range / 2;
            zOff = random.nextInt(range + 1) - range / 2;
        } while (xOff == 0 && zOff == 0);
        BlockPos newPos = pos.offset(xOff, 10, zOff);
        for (int i = 0; i < 20 && (stateAt = worldIn.getBlockState(newPos)).getBlock() != Blocks.END_STONE; ++i) {
            newPos = newPos.below();
        }
        if (worldIn.getBlockState(newPos).getBlock() == Blocks.END_STONE && worldIn.getBlockState(newPos.above()).isAir()) {
            newPos = newPos.above();
            worldIn.setBlockAndUpdate(newPos, state);
            if (random.nextDouble() < growthChance) {
                worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                worldIn.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() - 0.25, (double)pos.getZ(), 50, 0.25, 0.25, 0.25, 1.0);
                worldIn.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.1f, 5.0f + random.nextFloat());
            }
            worldIn.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)newPos.getX() + 0.5, (double)newPos.getY() - 0.25, (double)newPos.getZ(), 50, 0.25, 0.25, 0.25, 0.05);
            return newPos;
        }
        return null;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level worldIn, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel worldIn, RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        for (int i = 0; i < 3 + rand.nextInt(3); ++i) {
            this.teleport(pos, rand, worldIn, state, 10, 0.0);
        }
        this.teleport(pos, rand, worldIn, state, 4, 1.0);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).getBlock() == Blocks.END_STONE;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, type);
    }
}

