/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.catnip.animation.AnimationTickHolder;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.resources.AttributeIconEntry;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;
import org.violetmoon.zeta.event.play.ZSkipAttributeTooltip;

public class AttributeTooltips {
    public static final ResourceLocation TEXTURE_UPGRADE = Quark.asResource("textures/attribute/upgrade.png");
    public static final ResourceLocation TEXTURE_DOWNGRADE = Quark.asResource("textures/attribute/downgrade.png");
    private static final Map<ResourceLocation, AttributeIconEntry> attributes = new HashMap<ResourceLocation, AttributeIconEntry>();

    public static void receiveAttributes(Map<String, AttributeIconEntry> map) {
        attributes.clear();
        for (Map.Entry<String, AttributeIconEntry> entry : map.entrySet()) {
            attributes.put(ResourceLocation.parse((String)entry.getKey()), entry.getValue());
        }
    }

    @Nullable
    private static AttributeIconEntry getIconForAttribute(Holder<Attribute> attribute) {
        ResourceLocation loc = attribute.getKey().location();
        if (loc != null) {
            return attributes.get(loc);
        }
        return null;
    }

    private static MutableComponent format(ItemAttributeModifiers.Entry entry, double baseVal) {
        double value = entry.modifier().amount();
        switch (entry.modifier().operation()) {
            case ADD_VALUE: {
                return Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value + baseVal).formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE));
            }
            case ADD_MULTIPLIED_BASE: {
                return Component.literal((String)((value > 0.0 ? "+" : "") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value * 100.0).formatted(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE) + "%"));
            }
            case ADD_MULTIPLIED_TOTAL: {
                AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER);
                double scaledValue = value / supplier.getBaseValue(entry.attribute());
                return Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(scaledValue) + "x")).withStyle(scaledValue < 1.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
        }
        return Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value)).withStyle(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!Screen.hasShiftDown() && stack.has(DataComponents.ATTRIBUTE_MODIFIERS) && !((ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().isEmpty()) {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            List tooltipRaw = event.getTooltipElements();
            tooltipRaw.add(1, Either.right((Object)new AttributeComponent(stack)));
        }
    }

    public static void removeAttributeTooltips(ZSkipAttributeTooltip skipAttributeTooltip) {
        skipAttributeTooltip.setSkipAll(!Screen.hasShiftDown());
    }

    private static int renderAttribute(GuiGraphics guiGraphics, ItemAttributeModifiers.Entry entry, int x, int y, Minecraft mc, @Nullable ItemAttributeModifiers.Entry differenceInAttribute) {
        AttributeIconEntry iconEntry = AttributeTooltips.getIconForAttribute((Holder<Attribute>)entry.attribute());
        if (iconEntry != null) {
            guiGraphics.blit(iconEntry.texture(), x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            double baseVal = mc.player.getAttributeBaseValue(entry.attribute());
            if (ImprovedTooltipsModule.showUpgradeStatus && differenceInAttribute != null) {
                MutableComponent valueStr = AttributeTooltips.format(entry, baseVal).withStyle(differenceInAttribute.modifier().amount() > 0.0 ? ChatFormatting.GREEN : (differenceInAttribute.modifier().amount() < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE));
                guiGraphics.drawString(mc.font, (Component)valueStr, x + 12, y + 1, -1);
                if (differenceInAttribute.modifier().amount() != 0.0) {
                    int xp = x - 2;
                    int yp = y - 2;
                    if (ImprovedTooltipsModule.animateUpDownArrows && (float)AnimationTickHolder.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() % 20.0f < 10.0f) {
                        ++yp;
                    }
                    guiGraphics.blit(differenceInAttribute.modifier().amount() < 0.0 ? TEXTURE_DOWNGRADE : TEXTURE_UPGRADE, xp, yp, 0.0f, 0.0f, 13, 13, 13, 13);
                }
                x += mc.font.width((FormattedText)valueStr) + 20;
            } else {
                MutableComponent valueStr = AttributeTooltips.format(entry, baseVal);
                guiGraphics.drawString(mc.font, (Component)valueStr, x + 12, y + 1, -1);
                x += mc.font.width((FormattedText)valueStr) + 20;
            }
        }
        return x;
    }

    public static ItemAttributeModifiers simplifyStackAttributes(ItemStack stack) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        ArrayList<ItemAttributeModifiers.Entry> simplifiedList = new ArrayList<ItemAttributeModifiers.Entry>();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            boolean addedToList = false;
            for (int j = 0; j < simplifiedList.size(); ++j) {
                ItemAttributeModifiers.Entry simplifiedEntry = (ItemAttributeModifiers.Entry)simplifiedList.get(j);
                if (!simplifiedEntry.attribute().equals((Object)entry.attribute()) || !simplifiedEntry.modifier().operation().equals((Object)entry.modifier().operation()) || !simplifiedEntry.slot().equals((Object)entry.slot())) continue;
                double value = entry.modifier().amount();
                switch (entry.modifier().operation()) {
                    case ADD_VALUE: 
                    case ADD_MULTIPLIED_BASE: {
                        value += simplifiedEntry.modifier().amount();
                        break;
                    }
                    case ADD_MULTIPLIED_TOTAL: {
                        value *= simplifiedEntry.modifier().amount();
                    }
                }
                simplifiedList.set(j, new ItemAttributeModifiers.Entry(entry.attribute(), new AttributeModifier(entry.modifier().id(), value, entry.modifier().operation()), entry.slot()));
                addedToList = true;
                break;
            }
            if (addedToList) continue;
            simplifiedList.add(entry);
        }
        return new ItemAttributeModifiers(simplifiedList, modifiers.showInTooltip());
    }

    public static ItemAttributeModifiers compareAttributesOfStacks(ItemStack firstStack, ItemStack secondStack) {
        ItemAttributeModifiers simplifiedFirstStackMod = AttributeTooltips.simplifyStackAttributes(firstStack);
        ItemAttributeModifiers simplifiedSecondStackMod = AttributeTooltips.simplifyStackAttributes(secondStack);
        ArrayList<ItemAttributeModifiers.Entry> comparedModifs = new ArrayList<ItemAttributeModifiers.Entry>();
        block0: for (ItemAttributeModifiers.Entry firstEntry : simplifiedFirstStackMod.modifiers()) {
            for (ItemAttributeModifiers.Entry secondEntry : simplifiedSecondStackMod.modifiers()) {
                if (!secondEntry.attribute().equals((Object)firstEntry.attribute()) || !secondEntry.modifier().operation().equals((Object)firstEntry.modifier().operation()) || !secondEntry.slot().equals((Object)firstEntry.slot())) continue;
                comparedModifs.add(new ItemAttributeModifiers.Entry(secondEntry.attribute(), new AttributeModifier(secondEntry.modifier().id(), secondEntry.modifier().amount() - firstEntry.modifier().amount(), secondEntry.modifier().operation()), secondEntry.slot()));
                continue block0;
            }
        }
        return new ItemAttributeModifiers(comparedModifs, simplifiedSecondStackMod.showInTooltip());
    }

    public record AttributeComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.pose();
            if (!Screen.hasShiftDown()) {
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 500.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.getInstance();
                LocalPlayer player = mc.player;
                ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
                int x = tooltipX;
                int y = tooltipY - 1;
                ArrayList<EquipmentSlotGroup> groups = new ArrayList<EquipmentSlotGroup>();
                for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                    if (groups.contains(entry.slot())) continue;
                    groups.add(entry.slot());
                }
                boolean shouldSeparateFromMain = groups.size() > 1;
                ItemStack comparedItem = player.getItemBySlot(player.getEquipmentSlotForItem(this.stack));
                for (EquipmentSlotGroup slotGroup : groups) {
                    int groupX = tooltipX;
                    if (shouldSeparateFromMain) {
                        guiGraphics.blit(ClientUtil.GENERAL_ICONS, groupX, y, (float)(193 + slotGroup.ordinal() * 9), 35.0f, 9, 9, 256, 256);
                        groupX += 16;
                    }
                    if (!comparedItem.isEmpty() && !comparedItem.equals(this.stack) && comparedItem.has(DataComponents.ATTRIBUTE_MODIFIERS) && !((ItemAttributeModifiers)comparedItem.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().isEmpty()) {
                        ItemAttributeModifiers differenceInModifiers = AttributeTooltips.compareAttributesOfStacks(comparedItem, this.stack);
                        for (ItemAttributeModifiers.Entry entry : AttributeTooltips.simplifyStackAttributes(this.stack).modifiers()) {
                            if (entry.slot() != slotGroup) continue;
                            ItemAttributeModifiers.Entry diffAttribute = null;
                            for (ItemAttributeModifiers.Entry potentialDiffAttribute : differenceInModifiers.modifiers()) {
                                if (!potentialDiffAttribute.modifier().operation().equals((Object)entry.modifier().operation()) || !potentialDiffAttribute.slot().equals((Object)entry.slot()) || !potentialDiffAttribute.attribute().equals((Object)entry.attribute())) continue;
                                diffAttribute = potentialDiffAttribute;
                                break;
                            }
                            groupX = AttributeTooltips.renderAttribute(guiGraphics, entry, groupX, y, mc, diffAttribute);
                        }
                    } else {
                        for (ItemAttributeModifiers.Entry entry : AttributeTooltips.simplifyStackAttributes(this.stack).modifiers()) {
                            if (entry.slot() != slotGroup) continue;
                            groupX = AttributeTooltips.renderAttribute(guiGraphics, entry, groupX, y, mc, null);
                        }
                    }
                    x = groupX;
                    y += 10;
                }
                pose.popPose();
            }
        }

        public int getHeight() {
            int y = 0;
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (modifiers.showInTooltip()) {
                ArrayList<EquipmentSlotGroup> groups = new ArrayList<EquipmentSlotGroup>();
                for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                    if (groups.contains(entry.slot())) continue;
                    groups.add(entry.slot());
                }
                y = groups.size() * 10;
            }
            return y;
        }

        public int getWidth(@NotNull Font font) {
            int width = 8;
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            Minecraft mc = Minecraft.getInstance();
            if (modifiers.showInTooltip()) {
                ArrayList<EquipmentSlotGroup> groups = new ArrayList<EquipmentSlotGroup>();
                for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                    if (groups.contains(entry.slot())) continue;
                    groups.add(entry.slot());
                }
                int x = 0;
                for (EquipmentSlotGroup slotGroup : groups) {
                    int groupX = 0;
                    if (groups.size() > 1) {
                        groupX += 16;
                    }
                    for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                        if (entry.slot() != slotGroup) continue;
                        double baseVal = mc.player.getAttributeBaseValue(entry.attribute());
                        groupX += mc.font.width((FormattedText)AttributeTooltips.format(entry, baseVal)) + 20;
                    }
                    x = Math.max(x, groupX);
                }
                width = x;
            }
            return width - 8;
        }
    }
}

