/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.module.FramedGlassModule;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.AzaleaWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.quark.datagen.QuarkTags;

public class QuarkBlockTagProvider
extends BlockTagsProvider {
    public QuarkBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "quark", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addToQuarkTags(provider);
        this.addToVanillaTags(provider);
        this.addToConventionTags(provider);
        this.addToOtherModTags(provider);
    }

    private void addToQuarkTags(HolderLookup.Provider provider) {
        for (Block block : AncientWoodModule.woodSet.allLogs()) {
            this.tag(QuarkTags.Blocks.ANCIENT_LOGS).add((Object)block);
        }
        for (Block block : AzaleaWoodModule.woodSet.allLogs()) {
            this.tag(QuarkTags.Blocks.AZALEA_LOGS).add((Object)block);
        }
        for (Block block : BlossomTreesModule.woodSet.allLogs()) {
            this.tag(QuarkTags.Blocks.BLOSSOM_LOGS).add((Object)block);
        }
        for (Block block : CorundumModule.crystals) {
            this.tag(QuarkTags.Blocks.CORUNDUM).add((Object)block);
        }
        for (Block block : RainbowLampsModule.lamps) {
            this.tag(QuarkTags.Blocks.CRYSTAL_LAMP).add((Object)block);
        }
        this.tag(QuarkTags.Blocks.FRAMED_GLASS_PANES).add((Object)FramedGlassModule.framed_glass_pane).addTag(QuarkTags.Blocks.STAINED_FRAMED_GLASS_PANES);
        this.tag(QuarkTags.Blocks.FRAMED_GLASSES).add((Object)FramedGlassModule.framed_glass).addTag(QuarkTags.Blocks.STAINED_FRAMED_GLASSES);
        for (Block block : FramedGlassModule.stainedFramedGlass) {
            this.tag(QuarkTags.Blocks.STAINED_FRAMED_GLASSES).add((Object)block);
        }
        for (Block block : FramedGlassModule.stainedFramedGlass) {
            this.tag(QuarkTags.Blocks.STAINED_FRAMED_GLASSES).add((Object)block);
        }
        this.tag(QuarkTags.Blocks.CRAB_SPAWNABLE).add((Object)Blocks.SAND).add((Object)Blocks.RED_SAND);
        this.tag(QuarkTags.Blocks.FALLEN_LOG_CAN_SPAWN_ON).add((Object)Blocks.DIRT);
        this.tag(QuarkTags.Blocks.FOXHOUND_SPAWNABLE).add((Object)Blocks.NETHERRACK).add((Object)Blocks.SOUL_SAND).add((Object)Blocks.SOUL_SOIL).add((Object)Blocks.BASALT);
        this.tag(QuarkTags.Blocks.BEACON_TRANSPARENT).add((Object)Blocks.BEDROCK);
    }

    private void addToVanillaTags(HolderLookup.Provider provider) {
        for (Block log : AncientWoodModule.woodSet.allLogs()) {
            this.tag(BlockTags.LOGS_THAT_BURN).add((Object)log);
        }
    }

    private void addToConventionTags(HolderLookup.Provider provider) {
        for (Block block : VariantBookshelvesModule.variantBookshelves) {
            this.tag(Tags.Blocks.BOOKSHELVES).add((Object)block);
        }
    }

    private void addToOtherModTags(HolderLookup.Provider provider) {
    }
}

