/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.client.particle.MagnetParticle;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.base.Quark;

@EventBusSubscriber(modid="quark", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class MagnetParticleRenderType {
    private static Supplier<ShaderInstance> PARTICLE_SHADER = GameRenderer::getParticleShader;
    public static final ParticleRenderType ADDITIVE_TRANSLUCENCY = new ParticleRenderType(){

        @NotNull
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.activeTexture((int)33984);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(PARTICLE_SHADER);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "PARTICLE_SHEET_ADDITIVE_TRANSLUCENT";
        }
    };

    @SubscribeEvent
    public static void registerShader(RegisterShadersEvent event) {
        try {
            ShaderInstance translucentParticleShader = new ShaderInstance(event.getResourceProvider(), Quark.asResource("particle_no_alpha_cutoff"), DefaultVertexFormat.POSITION_TEX);
            event.registerShader(translucentParticleShader, s -> {
                PARTICLE_SHADER = () -> s;
            });
        }
        catch (Exception e) {
            Quark.LOG.error("Failed to parse shader: " + String.valueOf(e));
        }
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)MagnetsModule.attractorParticle, MagnetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)MagnetsModule.repulsorParticle, MagnetParticle.Provider::new);
    }
}

