/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.tools.module.PathfinderMapsModule;

public record InBiomeCondition(ResourceLocation target) implements LootItemCondition
{
    public static final MapCodec<InBiomeCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("target").forGetter(InBiomeCondition::target)).apply((Applicative)builder, InBiomeCondition::new));

    public boolean test(LootContext lootContext) {
        Vec3 pos = (Vec3)lootContext.getParam(LootContextParams.ORIGIN);
        return lootContext.getLevel().getBiome(BlockPos.containing((Position)pos)).is(this.target);
    }

    @NotNull
    public LootItemConditionType getType() {
        return PathfinderMapsModule.inBiomeConditionType;
    }
}

