/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.api.ICrawlSpaceBlock;
import org.violetmoon.zeta.block.ZetaPillarBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class HollowPillarBlock
extends ZetaPillarBlock
implements SimpleWaterloggedBlock,
ICrawlSpaceBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_X = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{SHAPE_TOP, SHAPE_EAST, SHAPE_WEST});
    private static final VoxelShape SHAPE_Y = Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape[])new VoxelShape[]{SHAPE_SOUTH, SHAPE_EAST, SHAPE_WEST});
    private static final VoxelShape SHAPE_Z = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{SHAPE_TOP, SHAPE_NORTH, SHAPE_SOUTH});

    public HollowPillarBlock(String regname, ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canCrawl(Level level, BlockState state, BlockPos pos, Direction direction) {
        return state.getValue((Property)AXIS) == direction.getAxis();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            case Direction.Axis.Z -> SHAPE_Z;
        };
    }

    public boolean isLadderZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (state.getValue((Property)AXIS) != Direction.Axis.Y) {
            return false;
        }
        Vec3 eyePos = entity.getEyePosition();
        double pad = 0.125;
        if (eyePos.x > (double)pos.getX() + pad && eyePos.z > (double)pos.getZ() + pad && eyePos.x < (double)(pos.getX() + 1) - pad && eyePos.z < (double)(pos.getZ() + 1) - pad) {
            return true;
        }
        return super.isLadderZeta(state, level, pos, entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false && state.getValue((Property)AXIS) == Direction.Axis.Y;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public boolean useShapeForLightOcclusion(BlockState p_56967_) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> def) {
        super.createBlockStateDefinition(def);
        def.add(new Property[]{WATERLOGGED});
    }
}

