/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biomes;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class MoreVillagersModule
extends ZetaModule {
    @Config
    public boolean oceanVillager = true;
    @Config
    public boolean beachVillager = true;
    public static final VillagerType beach = new VillagerType("beach");
    public static final VillagerType ocean = new VillagerType("ocean");

    @LoadEvent
    public final void register(ZRegister event) {
        event.getRegistry().register((Object)beach, "beach", Registries.VILLAGER_TYPE);
        event.getRegistry().register((Object)ocean, "ocean", Registries.VILLAGER_TYPE);
    }

    @LoadEvent
    public final void onCommonSetup(ZCommonSetup event) {
        if (this.isEnabled()) {
            HashMap<ResourceKey, VillagerType> map = new HashMap<ResourceKey, VillagerType>(VillagerType.BY_BIOME);
            if (this.oceanVillager) {
                map.put(Biomes.WARM_OCEAN, ocean);
                map.put(Biomes.LUKEWARM_OCEAN, ocean);
                map.put(Biomes.DEEP_LUKEWARM_OCEAN, ocean);
                map.put(Biomes.OCEAN, ocean);
                map.put(Biomes.DEEP_OCEAN, ocean);
                map.put(Biomes.COLD_OCEAN, ocean);
                map.put(Biomes.DEEP_COLD_OCEAN, ocean);
                map.put(Biomes.FROZEN_OCEAN, ocean);
                map.put(Biomes.DEEP_FROZEN_OCEAN, ocean);
            }
            if (this.beachVillager) {
                map.put(Biomes.BEACH, beach);
            }
            VillagerType.BY_BIOME = map;
        }
    }

    public static void addExtraTrades(ImmutableMap.Builder<VillagerType, Item> original) {
        original.put((Object)beach, (Object)Items.JUNGLE_BOAT);
        original.put((Object)ocean, (Object)Items.OAK_BOAT);
    }
}

