/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.module.WraithModule;

public class Wraith
extends Zombie {
    public static final ResourceKey<LootTable> LOOT_TABLE = Quark.asResourceKey(Registries.LOOT_TABLE, "entities/wraith");
    private static final EntityDataAccessor<String> IDLE_SOUND = SynchedEntityData.defineId(Wraith.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> HURT_SOUND = SynchedEntityData.defineId(Wraith.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DEATH_SOUND = SynchedEntityData.defineId(Wraith.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final String TAG_IDLE_SOUND = "IdleSound";
    private static final String TAG_HURT_SOUND = "HurtSound";
    private static final String TAG_DEATH_SOUND = "DeathSound";
    boolean aggroed = false;

    public Wraith(EntityType<? extends Wraith> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IDLE_SOUND, (Object)"");
        builder.define(HURT_SOUND, (Object)"");
        builder.define(DEATH_SOUND, (Object)"");
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 0.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    protected void populateDefaultEquipmentSlots(RandomSource rand, @NotNull DifficultyInstance difficulty) {
    }

    protected SoundEvent getAmbientSound() {
        return this.getSound(IDLE_SOUND);
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return this.getSound(HURT_SOUND);
    }

    protected SoundEvent getDeathSound() {
        return this.getSound(DEATH_SOUND);
    }

    public float getVoicePitch() {
        return this.random.nextFloat() * 0.1f + 0.75f;
    }

    public SoundEvent getSound(EntityDataAccessor<String> param) {
        ResourceLocation loc = ResourceLocation.parse((String)((String)this.entityData.get(param)));
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(loc);
    }

    public void tick() {
        super.tick();
        double pad = 0.2;
        AABB aabb = this.getBoundingBox();
        double x = aabb.minX + Math.random() * (aabb.maxX - aabb.minX + pad * 2.0) - pad;
        double y = aabb.minY + Math.random() * (aabb.maxY - aabb.minY + pad * 2.0) - pad;
        double z = aabb.minZ + Math.random() * (aabb.maxZ - aabb.minZ + pad * 2.0) - pad;
        this.level().addParticle((ParticleOptions)ParticleTypes.MYCELIUM, x, y, z, 0.0, 0.0, 0.0);
        if (Math.random() < 0.1) {
            y = aabb.minY + 0.1;
            this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public boolean doHurtTarget(@NotNull Entity entityIn) {
        boolean did = super.doHurtTarget(entityIn);
        if (did) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            }
            double dx = this.getX() - entityIn.getX();
            double dz = this.getZ() - entityIn.getZ();
            Vec3 vec = new Vec3(dx, 0.0, dz).normalize().add(0.0, 0.5, 0.0).normalize().scale(0.85);
            this.setDeltaMovement(vec);
        }
        return did;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn) {
        int idx = this.random.nextInt(WraithModule.validWraithSounds.size());
        String sound = WraithModule.validWraithSounds.get(idx);
        String[] split = sound.split("\\|");
        this.entityData.set(IDLE_SOUND, (Object)split[0]);
        this.entityData.set(HURT_SOUND, (Object)split[1]);
        this.entityData.set(DEATH_SOUND, (Object)split[2]);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString(TAG_IDLE_SOUND, (String)this.entityData.get(IDLE_SOUND));
        compound.putString(TAG_HURT_SOUND, (String)this.entityData.get(HURT_SOUND));
        compound.putString(TAG_DEATH_SOUND, (String)this.entityData.get(DEATH_SOUND));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(IDLE_SOUND, (Object)compound.getString(TAG_IDLE_SOUND));
        this.entityData.set(HURT_SOUND, (Object)compound.getString(TAG_HURT_SOUND));
        this.entityData.set(DEATH_SOUND, (Object)compound.getString(TAG_DEATH_SOUND));
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LOOT_TABLE;
    }

    public void setBaby(boolean childZombie) {
    }

    public boolean isBaby() {
        return false;
    }

    public float getWalkTargetValue(@NotNull BlockPos pos, LevelReader worldIn) {
        BlockState state = worldIn.getBlockState(pos);
        return state.is(WraithModule.wraithSpawnableTag) ? 1.0f : 0.0f;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!super.hurt(source, amount)) {
            return false;
        }
        if (source != null && source.getDirectEntity() instanceof Player) {
            this.aggroed = true;
        }
        return this.level() instanceof ServerLevel;
    }

    public void setTarget(LivingEntity target) {
        if (this.aggroed) {
            super.setTarget(target);
        }
    }

    protected void handleAttributes(float difficulty) {
    }
}

