/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.inventory;

import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.management.inventory.HeldShulkerBoxMenu;
import org.violetmoon.quark.content.management.module.ExpandedItemInteractionsModule;

public class HeldShulkerBoxContainer
implements Container,
MenuProvider {
    public final Player player;
    public final ItemStack stack;
    public final ShulkerBoxBlockEntity be;
    public final int slot;

    public HeldShulkerBoxContainer(Player player, int slot) {
        BlockEntity tile;
        this.player = player;
        this.slot = slot;
        this.stack = player.getInventory().getItem(slot);
        ShulkerBoxBlockEntity gotBe = null;
        if (SimilarBlockTypeHandler.isShulkerBox(this.stack) && (tile = ExpandedItemInteractionsModule.getShulkerBoxEntity(this.stack, player.level().registryAccess())) instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulker;
            gotBe = shulker = (ShulkerBoxBlockEntity)tile;
        }
        if (this.stack.has(DataComponents.CONTAINER) && gotBe != null) {
            for (int i = 0; i < ((ItemContainerContents)this.stack.get(DataComponents.CONTAINER)).getSlots(); ++i) {
                gotBe.setItem(i, ((ItemContainerContents)this.stack.get(DataComponents.CONTAINER)).getStackInSlot(i));
            }
        }
        this.be = gotBe;
    }

    public AbstractContainerMenu createMenu(int containerID, Inventory playerInv, Player player) {
        return new HeldShulkerBoxMenu(containerID, playerInv, this, this.slot);
    }

    public Component getDisplayName() {
        return this.be.getDisplayName();
    }

    public void clearContent() {
        this.be.clearContent();
    }

    public int getContainerSize() {
        return this.be.getContainerSize();
    }

    public boolean isEmpty() {
        return this.be.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.be.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.be.removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.be.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.be.setItem(slot, itemStack);
    }

    public void setChanged() {
        this.be.setChanged();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.be.getContainerSize(); ++i) {
            stacks.add(this.getItem(i));
        }
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks));
    }

    public boolean stillValid(Player player) {
        return this.stack != null && player == this.player && player.getInventory().getItem(this.slot) == this.stack;
    }
}

