/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.platform.Window;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZInputUpdate;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class AutoWalkKeybindModule
extends ZetaModule {
    @Config
    public static boolean drawHud = true;
    @Config
    public static int hudHeight = 10;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AutoWalkKeybindModule {
        private KeyMapping keybind;
        private boolean autorunning;
        private boolean hadAutoJump;
        private boolean shouldAccept;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.keybind = event.init("quark.keybind.autorun", null, "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            this.acceptInput();
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            this.acceptInput();
        }

        @PlayEvent
        public void drawHUD(ZRenderGuiOverlay.Post event) {
            if (drawHud && event.getLayerName().equals((Object)VanillaGuiLayers.HOTBAR) && this.autorunning && !Minecraft.getInstance().options.hideGui) {
                String message = I18n.get((String)"quark.misc.autowalking", (Object[])new Object[0]);
                GuiGraphics guiGraphics = event.getGuiGraphics();
                Minecraft mc = Minecraft.getInstance();
                int w = mc.font.width("OoO" + message + "oOo");
                Window window = event.getWindow();
                int x = (window.getGuiScaledWidth() - w) / 2;
                int y = hudHeight;
                Object displayMessage = message;
                int time = (int)(Util.timeSource.get(TimeUnit.MILLISECONDS) / 500L % 2L);
                switch (time) {
                    case 0: {
                        displayMessage = "OoO " + message + " oOo";
                        break;
                    }
                    case 1: {
                        displayMessage = "oOo " + message + " OoO";
                    }
                }
                guiGraphics.drawString(mc.font, (String)displayMessage, x, y, -1, true);
            }
        }

        private void acceptInput() {
            Minecraft mc = Minecraft.getInstance();
            OptionInstance opt = mc.options.autoJump();
            if (mc.options.keyUp.isDown()) {
                if (this.autorunning) {
                    opt.set((Object)this.hadAutoJump);
                }
                this.autorunning = false;
            } else if (this.keybind.isDown()) {
                if (this.shouldAccept) {
                    this.shouldAccept = false;
                    LocalPlayer player = mc.player;
                    AttributeInstance stepHeight = player.getAttribute(Attributes.STEP_HEIGHT);
                    if (stepHeight != null) {
                        double height = stepHeight.getValue();
                        boolean bl = this.autorunning = !this.autorunning;
                        if (this.autorunning) {
                            this.hadAutoJump = (Boolean)opt.get();
                            if (height < 1.0) {
                                opt.set((Object)true);
                            }
                        } else {
                            opt.set((Object)this.hadAutoJump);
                        }
                    }
                }
            } else {
                this.shouldAccept = true;
            }
        }

        @PlayEvent
        public void onInput(ZInputUpdate event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && this.autorunning) {
                Input input = event.getInput();
                input.up = true;
                input.forwardImpulse = ((LocalPlayer)event.getEntity()).isMovingSlowly() ? 0.3f : 1.0f;
            }
        }
    }
}

