/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Shiba;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractArrow;

public class FetchArrowGoal
extends Goal {
    private final Shiba shiba;
    private int timeToRecalcPath;
    private final PathNavigation navigator;
    private int timeTilNextJump = 20;

    public FetchArrowGoal(Shiba shiba) {
        this.shiba = shiba;
        this.navigator = shiba.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tick() {
        double dist;
        AbstractArrow fetching = this.shiba.getFetching();
        if (fetching == null) {
            return;
        }
        this.shiba.getLookControl().setLookAt((Entity)fetching, 10.0f, (float)this.shiba.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.shiba.isLeashed() && !this.shiba.isPassenger()) {
                this.navigator.moveTo((Entity)fetching, 1.1);
            }
        }
        if ((dist = (double)this.shiba.distanceTo((Entity)fetching)) < 3.0 && fetching.isAlive()) {
            if (fetching.pickup == AbstractArrow.Pickup.ALLOWED) {
                this.shiba.setMouthItem(((AccessorAbstractArrow)fetching).quark$getPickupItem());
                fetching.discard();
            }
            if (dist < 1.0 && (fetching.pickup == AbstractArrow.Pickup.DISALLOWED || fetching.pickup == AbstractArrow.Pickup.CREATIVE_ONLY)) {
                this.shiba.level().playSound(null, this.shiba.blockPosition(), QuarkSounds.ENTITY_SHIBA_EAT_ARROW, SoundSource.NEUTRAL);
                fetching.discard();
            }
        }
        --this.timeTilNextJump;
        if (this.timeTilNextJump <= 0) {
            this.timeTilNextJump = this.shiba.level().random.nextInt(5) + 10;
            if (this.shiba.onGround()) {
                this.shiba.push(0.0, 0.3, 0.0);
                this.shiba.setJumping(true);
            }
        }
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean canUse() {
        AbstractArrow fetching = this.shiba.getFetching();
        return this.shiba.getMouthItem().isEmpty() && fetching != null && fetching.isAlive() && fetching.level() == this.shiba.level() && fetching.pickup != AbstractArrow.Pickup.DISALLOWED;
    }
}

