/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaSlabBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class QuarkVerticalSlabBlock
extends VerticalSlabBlock
implements IZetaBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public QuarkVerticalSlabBlock(Block parent, ZetaModule module) {
        super(() -> parent, BlockPropertyUtil.copyPropertySafe(parent));
        String resloc = Quark.ZETA.registryUtil.inherit(parent, s -> s.replace("_slab", "_vertical_slab"));
        Quark.ZETA.registry.registerBlock((Block)this, resloc, true);
        this.module = module;
        if (!(parent instanceof SlabBlock)) {
            throw new IllegalArgumentException("Can't rotate a non-slab block into a vertical slab.");
        }
        if (parent instanceof ZetaSlabBlock) {
            ZetaSlabBlock quarkSlab = (ZetaSlabBlock)parent;
            this.setCondition(() -> ((IZetaBlock)quarkSlab.parent).isEnabled());
        }
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.BUILDING_BLOCKS, (ItemLike)this, (ItemLike)parent, (boolean)false);
        VerticalSlabsModule.blocks.put(parent, this);
    }

    public QuarkVerticalSlabBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }
}

