/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.addons.oddities.block.MagnetBlock;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagneticEntity;
import org.violetmoon.quark.content.automation.entity.Gravisand;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorServerGamePacketListener;
import org.violetmoon.zeta.api.ICollateralMover;

public class MagnetBlockEntity
extends BlockEntity {
    public MagnetBlockEntity(BlockPos pos, BlockState state) {
        super(MagnetsModule.magnetType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagnetBlockEntity be) {
        boolean powered = (Boolean)state.getValue((Property)MagnetBlock.POWERED);
        if (powered) {
            Direction dir = (Direction)state.getValue((Property)MagnetBlock.FACING);
            int power = level.getBestNeighborSignal(pos);
            be.magnetize(state, dir, dir, power);
            be.magnetize(state, dir.getOpposite(), dir, power);
        }
    }

    private void magnetize(BlockState state, Direction dir, Direction moveDir, int power) {
        int blockDist;
        if (this.level == null) {
            return;
        }
        double magnitude = dir == moveDir ? 1 : -1;
        for (blockDist = 1; blockDist <= power; ++blockDist) {
            BlockEntity blockEntity;
            BlockPos targetPos = this.worldPosition.relative(dir, blockDist);
            BlockState targetState = this.level.getBlockState(targetPos);
            if (!this.level.isClientSide) {
                ICollateralMover.MoveResult reaction = MagnetSystem.getPushAction(this, targetPos, targetState, moveDir);
                if (reaction == ICollateralMover.MoveResult.MOVE || reaction == ICollateralMover.MoveResult.BREAK) {
                    MagnetSystem.applyForce(this.level, targetPos, power - blockDist + 1, dir == moveDir, moveDir, blockDist, this.worldPosition);
                } else if (reaction == ICollateralMover.MoveResult.PREVENT) break;
            }
            if (targetState.getBlock() == MagnetsModule.magnetized_block && (blockEntity = this.level.getBlockEntity(targetPos)) instanceof MagnetizedBlockBlockEntity) {
                MagnetizedBlockBlockEntity mbe = (MagnetizedBlockBlockEntity)blockEntity;
                targetState = mbe.getBlockState();
            }
            if (!this.canFluxPenetrate(targetPos, targetState)) break;
        }
        if (MagnetsModule.affectEntities && blockDist > 1) {
            List entities = this.level.getEntities((Entity)null, new AABB(this.worldPosition).expandTowards(new Vec3(dir.step().mul((float)blockDist))), this::canPullEntity);
            for (Entity e : entities) {
                this.pushEntity(dir, magnitude, e);
            }
        }
        if (!((Boolean)state.getValue((Property)MagnetBlock.WAXED)).booleanValue()) {
            double particleMotion = 0.06 * magnitude;
            double particleChance = 0.2;
            double xOff = (double)dir.getStepX() * particleMotion;
            double yOff = (double)dir.getStepY() * particleMotion;
            double zOff = (double)dir.getStepZ() * particleMotion;
            double particleOffset = moveDir.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 : -1.0;
            for (int j = 1; j < blockDist; ++j) {
                if (!((double)this.level.random.nextFloat() <= particleChance)) continue;
                BlockPos targetPos = this.worldPosition.relative(dir, j);
                double x = (double)targetPos.getX() + this.getParticlePos(xOff, this.level.random, particleOffset);
                double y = (double)targetPos.getY() + this.getParticlePos(yOff, this.level.random, particleOffset);
                double z = (double)targetPos.getZ() + this.getParticlePos(zOff, this.level.random, particleOffset);
                SimpleParticleType p = dir == moveDir ? MagnetsModule.repulsorParticle : MagnetsModule.attractorParticle;
                this.level.addParticle((ParticleOptions)p, x, y, z, xOff, yOff, zOff);
            }
        }
    }

    private void pushEntity(Direction dir, double magnitude, Entity e) {
        if (e instanceof Gravisand) {
            magnitude = -magnitude;
        }
        double distanceFromMagnetSq = e.distanceToSqr(this.worldPosition.getCenter());
        double invSquared = 1.0 / distanceFromMagnetSq;
        Vec3 vec = new Vec3(dir.step().mul((float)(invSquared * magnitude * MagnetsModule.entitiesPullForce)));
        if (e instanceof IMagneticEntity) {
            IMagneticEntity me = (IMagneticEntity)e;
            me.moveByMagnet(e, vec, this);
        } else {
            e.push(vec.x(), vec.y(), vec.z());
            if (e instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e;
                ((AccessorServerGamePacketListener)player.connection).setAboveGroundTickCount(0);
            } else {
                e.hurtMarked = true;
            }
            if (e instanceof FallingBlockEntity) {
                FallingBlockEntity fb = (FallingBlockEntity)e;
                --fb.time;
            }
            e.fallDistance = 0.0f;
        }
    }

    private boolean canPullEntity(Entity e) {
        if (this.level.isClientSide) {
            if (MagnetsModule.affectsArmor && e instanceof Player) {
                Player player = (Player)e;
                for (ItemStack armor : player.getArmorSlots()) {
                    if (!MagnetSystem.isItemMagnetic(armor.getItem())) continue;
                    return true;
                }
            }
            return false;
        }
        if (e instanceof IMagneticEntity) {
            return true;
        }
        if (e instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)e;
            return MagnetSystem.isItemMagnetic(ie.getItem().getItem());
        }
        if (e.getType().is(MagnetsModule.magneticEntities)) {
            return true;
        }
        if (e instanceof FallingBlockEntity) {
            FallingBlockEntity fb = (FallingBlockEntity)e;
            return MagnetSystem.isBlockMagnetic(fb.getBlockState());
        }
        if (MagnetsModule.affectsArmor && e instanceof Player) {
            Player player = (Player)e;
            for (ItemStack armor : player.getArmorSlots()) {
                if (!MagnetSystem.isItemMagnetic(armor.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canFluxPenetrate(BlockPos targetPos, BlockState targetState) {
        return targetState.isAir() || targetState.getCollisionShape((BlockGetter)this.level, targetPos).isEmpty();
    }

    private double getParticlePos(double offset, RandomSource ran, double magnitude) {
        return offset == 0.0 ? (double)(0.5f + (ran.nextFloat() + ran.nextFloat() - 1.0f) / 2.0f) : 0.5 + magnitude * ((double)ran.nextFloat() - 1.25);
    }
}

