/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.tooltip.EnchantedBookTooltips;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.zeta.module.IDisableable;

public final class SmithingRuneRecipe
extends SmithingTrimRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient template;
    private final Ingredient addition;
    private final RuneColor runeColor;
    private static Ingredient used;

    private static ItemStack makeEnchantedDisplayItem(ItemStack input) {
        ItemStack stack = input.copy();
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"quark.jei.any_enchanted"));
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return stack;
    }

    private static Ingredient createBaseIngredient() {
        if (used == null) {
            Stream<Object> displayItems = Quark.ZETA.modules.isEnabled(ImprovedTooltipsModule.class) && ImprovedTooltipsModule.enchantingTooltips ? EnchantedBookTooltips.getTestItems().stream() : Stream.of(Items.DIAMOND_SWORD, Items.DIAMOND_PICKAXE, Items.DIAMOND_AXE, Items.DIAMOND_SHOVEL, Items.DIAMOND_HOE, Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS, Items.ELYTRA, Items.SHIELD, Items.BOW, Items.CROSSBOW, Items.TRIDENT, Items.FISHING_ROD, Items.SHEARS, PickarangModule.pickarang).map(ItemStack::new);
            used = Ingredient.of(displayItems.filter(it -> {
                IDisableable dis;
                Item patt0$temp = it.getItem();
                return !(patt0$temp instanceof IDisableable) || (dis = (IDisableable)patt0$temp).isEnabled();
            }).map(SmithingRuneRecipe::makeEnchantedDisplayItem));
        }
        return used;
    }

    private SmithingRuneRecipe(Ingredient template, Ingredient addition, RuneColor runeColor) {
        super(template, SmithingRuneRecipe.createBaseIngredient(), addition);
        this.template = template;
        this.addition = addition;
        this.runeColor = runeColor;
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        return this.isTemplateIngredient(input.getItem(0)) && this.isBaseIngredient(input.getItem(1)) && this.isAdditionIngredient(input.getItem(2));
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider provider) {
        ItemStack baseItem = input.getItem(1);
        if (this.isBaseIngredient(baseItem)) {
            if (ColorRunesModule.getStackColor(baseItem) == this.runeColor) {
                return ItemStack.EMPTY;
            }
            ItemStack newStack = baseItem.copy();
            newStack.setCount(1);
            return ColorRunesModule.withRune(newStack, this.runeColor);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        ItemStack displayStack = SmithingRuneRecipe.makeEnchantedDisplayItem(new ItemStack((ItemLike)Items.IRON_CHESTPLATE));
        ColorRunesModule.withRune(displayStack, this.runeColor);
        return displayStack;
    }

    public boolean isTemplateIngredient(@Nonnull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(@Nonnull ItemStack stack) {
        return ColorRunesModule.canHaveRune(stack);
    }

    public boolean isAdditionIngredient(@Nonnull ItemStack stack) {
        return this.addition.isEmpty() ? stack.isEmpty() : this.addition.test(stack);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    public static class Serializer
    implements RecipeSerializer<SmithingRuneRecipe> {
        public static final MapCodec<SmithingRuneRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("template").forGetter(smithingRuneRecipe -> smithingRuneRecipe.template), (App)Ingredient.CODEC.optionalFieldOf("addition", (Object)Ingredient.EMPTY).forGetter(smithingRuneRecipe -> smithingRuneRecipe.addition), (App)RuneColor.RUNE_COLOR_CODEC.fieldOf("color").forGetter(smithingRuneRecipe -> smithingRuneRecipe.runeColor)).apply((Applicative)inst, SmithingRuneRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingRuneRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmithingRuneRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmithingRuneRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingRuneRecipe fromNetwork(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)registryFriendlyByteBuf);
            RuneColor color = RuneColor.byName((String)ByteBufCodecs.stringUtf8((int)32).decode((Object)registryFriendlyByteBuf));
            Ingredient addition = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)registryFriendlyByteBuf);
            return new SmithingRuneRecipe(template, addition, color);
        }

        private static void toNetwork(RegistryFriendlyByteBuf registryFriendlyByteBuf, SmithingRuneRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)registryFriendlyByteBuf, (Object)recipe.template);
            ByteBufCodecs.stringUtf8((int)32).encode((Object)registryFriendlyByteBuf, (Object)recipe.runeColor.getSerializedName());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)registryFriendlyByteBuf, (Object)recipe.addition);
        }
    }
}

