/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.ItemEnchantsUtil;
import org.violetmoon.quark.content.tools.item.AncientTomeItem;
import org.violetmoon.quark.content.tools.loot.EnchantTome;
import org.violetmoon.quark.content.world.module.MonsterBoxModule;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorMerchantMenu;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZAddReloadListener;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.ZAnvilRepair;
import org.violetmoon.zeta.event.play.ZAnvilUpdate;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.event.play.loading.ZLootTableLoad;
import org.violetmoon.zeta.event.play.loading.ZVillagerTrades;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class AncientTomesModule
extends ZetaModule {
    private static final Object mutex = new Object();
    @Config(description="Format is lootTable,weight. i.e. \"minecraft:chests/stronghold_library,30\"")
    public static List<String> lootTables = Lists.newArrayList((Object[])new String[]{AncientTomesModule.loot(BuiltInLootTables.STRONGHOLD_LIBRARY.location(), 20), AncientTomesModule.loot(BuiltInLootTables.SIMPLE_DUNGEON.location(), 20), AncientTomesModule.loot(BuiltInLootTables.BASTION_TREASURE.location(), 25), AncientTomesModule.loot(BuiltInLootTables.WOODLAND_MANSION.location(), 15), AncientTomesModule.loot(BuiltInLootTables.NETHER_BRIDGE.location(), 0), AncientTomesModule.loot(BuiltInLootTables.UNDERWATER_RUIN_BIG.location(), 0), AncientTomesModule.loot(BuiltInLootTables.UNDERWATER_RUIN_SMALL.location(), 0), AncientTomesModule.loot(BuiltInLootTables.ANCIENT_CITY.location(), 4), AncientTomesModule.loot(MonsterBoxModule.MONSTER_BOX_LOOT_TABLE, 5)});
    private static final Object2IntMap<ResourceLocation> lootTableWeights = new Object2IntArrayMap();
    @Config
    public static int itemQuality = 2;
    @Config
    public static int normalUpgradeCost = 10;
    @Config
    public static int limitBreakUpgradeCost = 30;
    public static LootItemFunctionType<EnchantTome> tomeEnchantType;
    @Config(name="Valid Enchantments")
    public static List<String> enchantNames;
    @Config
    public static boolean overleveledBooksGlowRainbow;
    @Config(description="When enabled, Efficiency VI Diamond and Netherite pickaxes can instamine Deepslate when under Haste 2", flag="deepslate_tweak")
    public static boolean deepslateTweak;
    @Config
    public static boolean deepslateTweakNeedsHaste2;
    @Config(description="Master Librarians will offer to exchange Ancient Tomes, provided you give them a max-level Enchanted Book of the Tome's enchantment too.")
    public static boolean librariansExchangeAncientTomes;
    @Config(description="Applying a tome will also randomly curse your item")
    public static boolean curseGear;
    @Config(description="Allows combining tomes with normal books")
    public static boolean combineWithBooks;
    @Config(description="Whether a sanity check is performed on the valid enchantments. If this is turned off, enchantments such as Silk Touch will be allowed to generate Ancient Tomes, if explicitly added to the Valid Enchantments.")
    public static boolean sanityCheck;
    @Hint
    public static Item ancient_tome;
    public static final List<Holder<Enchantment>> validEnchants;
    private static boolean initialized;
    public static ManualTrigger overlevelTrigger;
    public static ManualTrigger instamineDeepslateTrigger;
    private static final ResourceLocation OVERLEVEL_COLOR_HANDLER;
    private final List<Holder<Enchantment>> curses = new ArrayList<Holder<Enchantment>>();

    private static String loot(ResourceLocation lootLoc, int defaultWeight) {
        return lootLoc.toString() + "," + defaultWeight;
    }

    @LoadEvent
    public void register(ZRegister event) {
        ancient_tome = new AncientTomeItem(this);
        tomeEnchantType = new LootItemFunctionType(EnchantTome.CODEC);
        Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)Quark.asResource("tome_enchant"), tomeEnchantType);
        overlevelTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("overlevel");
        instamineDeepslateTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("instamine_deepslate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlayEvent
    public void onTradesLoaded(ZVillagerTrades event) {
        if (event.getType() == VillagerProfession.LIBRARIAN && librariansExchangeAncientTomes) {
            Object object = mutex;
            synchronized (object) {
                Int2ObjectMap trades = event.getTrades();
                ((List)trades.get(5)).add(new ExchangeAncientTomesTrade());
            }
        }
    }

    @LoadEvent
    public void configChanged(ZConfigChanged event) {
        lootTableWeights.clear();
        for (String table : lootTables) {
            int weight;
            String[] split = table.split(",");
            if (split.length != 2) continue;
            ResourceLocation loc = ResourceLocation.parse((String)split[0]);
            try {
                weight = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (weight <= 0) continue;
            lootTableWeights.put((Object)loc, weight);
        }
    }

    @LoadEvent
    public void setup(ZCommonSetup event) {
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        ResourceLocation res = event.getName();
        int weight = lootTableWeights.getOrDefault((Object)res, 0);
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.lootTableItem((ItemLike)ancient_tome).setWeight(weight).setQuality(itemQuality).apply(() -> new EnchantTome(List.of(new LootItemCondition[0]))).build();
            event.add(entry);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    @PlayEvent
    public void onDataLoad(ZAddReloadListener event) {
        Registry enchRegistry = event.getServerResources().fullRegistries().get().registryOrThrow(Registries.ENCHANTMENT);
        validEnchants.clear();
        for (String s : enchantNames) {
            ResourceKey realsourceKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)s));
            Optional optHeld = enchRegistry.getHolder(realsourceKey);
            if (optHeld.isEmpty()) {
                Quark.LOG.error("Unknown enchantment found for Tomes!");
                continue;
            }
            validEnchants.add((Holder<Enchantment>)((Holder)optHeld.get()));
        }
        if (sanityCheck) {
            validEnchants.removeIf(ench -> ((Enchantment)ench.value()).getMaxLevel() == 1);
        }
        for (Holder e : enchRegistry.asHolderIdMap()) {
            if (!e.is(EnchantmentTags.CURSE)) continue;
            this.curses.add((Holder<Enchantment>)e);
        }
    }

    @PlayEvent
    public void onAnvilUpdate(ZAnvilUpdate.Highest event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String name = event.getName();
        if (!left.isEmpty() && !right.isEmpty() && left.getCount() == 1 && right.getCount() == 1) {
            if (right.is(ancient_tome)) {
                if (!combineWithBooks && left.is(Items.ENCHANTED_BOOK)) {
                    return;
                }
                Holder<Enchantment> ench = AncientTomesModule.getTomeEnchantment(right);
                ItemEnchantments enchants = (ItemEnchantments)left.get(DataComponents.ENCHANTMENTS);
                if (ench != null && enchants.keySet().contains(ench) && enchants.getLevel(ench) <= ((Enchantment)ench.value()).getMaxLevel()) {
                    int cost;
                    int lvl = enchants.getLevel(ench) + 1;
                    enchants = ItemEnchantsUtil.addEnchantmentToList(enchants, ench, lvl);
                    ItemStack out = left.copy();
                    ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                    for (Map.Entry enchEntry : enchants.entrySet()) {
                        mutable.set((Holder)enchEntry.getKey(), ((Integer)enchEntry.getValue()).intValue());
                    }
                    EnchantmentHelper.setEnchantments((ItemStack)out, (ItemEnchantments)mutable.toImmutable());
                    int n = cost = lvl > ((Enchantment)ench.value()).getMaxLevel() ? limitBreakUpgradeCost : normalUpgradeCost;
                    if (!(name == null || name.isEmpty() || out.has(DataComponents.CUSTOM_NAME) && out.getHoverName().getString().equals(name))) {
                        out.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
                        ++cost;
                    }
                    event.setOutput(out);
                    event.setCost(cost);
                }
            } else if (combineWithBooks && right.is(Items.ENCHANTED_BOOK)) {
                ItemEnchantments enchants = (ItemEnchantments)right.get(DataComponents.ENCHANTMENTS);
                ItemEnchantments currentEnchants = (ItemEnchantments)left.get(DataComponents.ENCHANTMENTS);
                boolean hasOverLevel = false;
                boolean hasMatching = false;
                for (Object2IntMap.Entry entry : enchants.entrySet()) {
                    Holder enchantment = (Holder)entry.getKey();
                    if (enchantment == null) continue;
                    int level = entry.getIntValue();
                    if (level > ((Enchantment)enchantment.value()).getMaxLevel()) {
                        hasOverLevel = true;
                        if (!((Enchantment)enchantment.value()).canEnchant(left) && !left.is(Items.ENCHANTED_BOOK)) continue;
                        hasMatching = true;
                        Iterator iterator = currentEnchants.keySet().iterator();
                        while (iterator.hasNext()) {
                            Holder comparingEnchantment = (Holder)iterator.next();
                            if (comparingEnchantment == enchantment || ((Enchantment)comparingEnchantment.value()).exclusiveSet().contains(enchantment)) continue;
                            iterator.remove();
                        }
                        currentEnchants = ItemEnchantsUtil.addEnchantmentToList(currentEnchants, (Holder<Enchantment>)enchantment, level);
                        continue;
                    }
                    if (!((Enchantment)enchantment.value()).canEnchant(left)) continue;
                    boolean compatible = true;
                    for (Holder comparingEnchantment : currentEnchants.keySet()) {
                        if (comparingEnchantment == enchantment || comparingEnchantment == null || ((Enchantment)comparingEnchantment.value()).exclusiveSet().contains(enchantment)) continue;
                        compatible = false;
                        break;
                    }
                    if (!compatible) continue;
                    currentEnchants = ItemEnchantsUtil.addEnchantmentToList(currentEnchants, (Holder<Enchantment>)enchantment, level);
                }
                if (hasOverLevel && hasMatching) {
                    ItemStack out = left.copy();
                    out.set(DataComponents.ENCHANTMENTS, (Object)currentEnchants);
                    int cost = normalUpgradeCost;
                    if (!(name == null || name.isEmpty() || out.has(DataComponents.CUSTOM_NAME) && out.getHoverName().getString().equals(name))) {
                        out.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
                        ++cost;
                    }
                    event.setOutput(out);
                    event.setCost(cost);
                }
            }
        }
    }

    @PlayEvent
    public void onAnvilUse(ZAnvilRepair event) {
        LivingEntity livingEntity;
        ItemStack output = event.getOutput();
        ItemStack right = event.getRight();
        if (curseGear && (right.is(ancient_tome) || event.getLeft().is(ancient_tome))) {
            event.getOutput().enchant(this.curses.get(event.getEntity().level().random.nextInt(this.curses.size())), 1);
        }
        if (AncientTomesModule.isOverlevel(output) && (right.getItem() == Items.ENCHANTED_BOOK || right.getItem() == ancient_tome) && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            overlevelTrigger.trigger(sp);
        }
    }

    @PlayEvent
    public void onGetSpeed(ZPlayer.BreakSpeed event) {
        if (deepslateTweak) {
            Player player = event.getPlayer();
            ItemStack stack = player.getMainHandItem();
            BlockState state = event.getState();
            Holder.Reference efficiency = event.getPlayer().level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY);
            if (state.is(Blocks.DEEPSLATE) && EnchantmentHelper.getTagEnchantmentLevel((Holder)efficiency, (ItemStack)stack) >= 6 && event.getOriginalSpeed() >= 45.0f && (!deepslateTweakNeedsHaste2 || this.playerHasHaste2(player))) {
                event.setNewSpeed(100.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    instamineDeepslateTrigger.trigger(sp);
                }
            }
        }
    }

    private boolean playerHasHaste2(Player player) {
        MobEffectInstance inst = player.getEffect(MobEffects.DIG_SPEED);
        return inst != null && inst.getAmplifier() > 0;
    }

    private static boolean isOverlevel(ItemStack stack) {
        if (stack.has(DataComponents.ENCHANTMENTS)) {
            ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            for (Holder enchant : enchantments.keySet()) {
                int level;
                if (enchant == null || (level = enchantments.getLevel(enchant)) <= ((Enchantment)enchant.value()).getMaxLevel()) continue;
                return true;
            }
        }
        return false;
    }

    public static Rarity shiftRarity(ItemStack itemStack, Rarity returnValue) {
        return Quark.ZETA.modules.isEnabled(AncientTomesModule.class) && overleveledBooksGlowRainbow && itemStack.getItem() == Items.ENCHANTED_BOOK && AncientTomesModule.isOverlevel(itemStack) ? Rarity.EPIC : returnValue;
    }

    private static List<String> generateDefaultEnchantmentList() {
        ResourceKey[] enchants = new ResourceKey[]{Enchantments.FEATHER_FALLING, Enchantments.THORNS, Enchantments.SHARPNESS, Enchantments.SMITE, Enchantments.BANE_OF_ARTHROPODS, Enchantments.KNOCKBACK, Enchantments.FIRE_ASPECT, Enchantments.LOOTING, Enchantments.SWEEPING_EDGE, Enchantments.EFFICIENCY, Enchantments.UNBREAKING, Enchantments.FORTUNE, Enchantments.POWER, Enchantments.PUNCH, Enchantments.LUCK_OF_THE_SEA, Enchantments.LURE, Enchantments.LOYALTY, Enchantments.RIPTIDE, Enchantments.IMPALING, Enchantments.PIERCING};
        ArrayList<String> strings = new ArrayList<String>();
        for (ResourceKey e : enchants) {
            ResourceLocation regname = e.location();
            if (e == null || regname == null) continue;
            strings.add(regname.toString());
        }
        return strings;
    }

    public static void initializeEnchantmentList(Iterable<String> enchantNames, List<Holder<Enchantment>> enchants) {
        enchants.clear();
        for (String s : enchantNames) {
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)s));
        }
    }

    public void setupCursesList() {
    }

    public static Holder<Enchantment> getTomeEnchantment(ItemStack stack) {
        if (stack.getItem() != ancient_tome) {
            return null;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        List enchantList = enchantments.keySet().stream().toList();
        for (Holder enchantment : enchantList) {
            if (enchantment == null) continue;
            return enchantment;
        }
        return null;
    }

    private static boolean isAncientTomeOffer(MerchantOffer offer) {
        return offer.getCostA().is(ancient_tome) && offer.getCostB().is(Items.ENCHANTED_BOOK) && offer.getResult().is(ancient_tome);
    }

    public static void moveVillagerItems(MerchantMenu menu, MerchantContainer container, MerchantOffer offer) {
        if (AncientTomesModule.isAncientTomeOffer(offer) && container.getItem(0).isEmpty() && container.getItem(1).isEmpty()) {
            ItemStack costA = offer.getCostA();
            AncientTomesModule.moveFromInventoryToPaymentSlot(menu, container, offer, 0, costA);
            ItemStack costB = offer.getCostB();
            AncientTomesModule.moveFromInventoryToPaymentSlot(menu, container, offer, 1, costB);
        }
    }

    private static void moveFromInventoryToPaymentSlot(MerchantMenu menu, MerchantContainer container, MerchantOffer offer, int tradeSlot, ItemStack targetStack) {
        ((AccessorMerchantMenu)menu).invokeMoveFromInventoryToPaymentSlot(tradeSlot, new ItemCost(targetStack.getItemHolder(), targetStack.getCount(), DataComponentPredicate.allOf((DataComponentMap)targetStack.getComponents())));
        if (container.getItem(tradeSlot).isEmpty() && !targetStack.isEmpty()) {
            for (int slot = 3; slot < 39; ++slot) {
                ItemStack inSlot = ((Slot)menu.slots.get(slot)).getItem();
                ItemStack currentStack = container.getItem(tradeSlot);
                if (ItemStack.isSameItemSameComponents((ItemStack)inSlot, (ItemStack)offer.getResult()) || inSlot.isEmpty() || !(currentStack.isEmpty() ? offer.satisfiedBy(inSlot, targetStack) : ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)inSlot))) continue;
                int currentCount = currentStack.isEmpty() ? 0 : currentStack.getCount();
                int amountToTake = Math.min(targetStack.getMaxStackSize() - currentCount, inSlot.getCount());
                ItemStack newStack = inSlot.copy();
                int newCount = currentCount + amountToTake;
                inSlot.shrink(amountToTake);
                newStack.setCount(newCount);
                container.setItem(tradeSlot, newStack);
                if (newCount >= targetStack.getMaxStackSize()) break;
            }
        }
    }

    public static boolean matchWildcardEnchantedBook(MerchantOffer offer, ItemStack comparing, ItemStack reference) {
        ItemEnchantments referenceEnchants;
        if (AncientTomesModule.isAncientTomeOffer(offer) && comparing.is(Items.ENCHANTED_BOOK) && reference.is(Items.ENCHANTED_BOOK) && (referenceEnchants = (ItemEnchantments)reference.get(DataComponents.ENCHANTMENTS)).size() == 1) {
            Holder enchantment = (Holder)referenceEnchants.keySet().iterator().next();
            int level = referenceEnchants.getLevel(enchantment);
            ItemEnchantments comparingEnchants = (ItemEnchantments)comparing.get(DataComponents.ENCHANTMENTS);
            for (Object2IntMap.Entry entry : comparingEnchants.entrySet()) {
                if (entry.getKey() != enchantment || entry.getValue() < level) continue;
                return true;
            }
        }
        return false;
    }

    static {
        enchantNames = AncientTomesModule.generateDefaultEnchantmentList();
        overleveledBooksGlowRainbow = true;
        deepslateTweak = true;
        deepslateTweakNeedsHaste2 = true;
        librariansExchangeAncientTomes = true;
        curseGear = false;
        combineWithBooks = true;
        sanityCheck = true;
        validEnchants = new ArrayList<Holder<Enchantment>>();
        initialized = false;
        OVERLEVEL_COLOR_HANDLER = Quark.asResource("overlevel_rune");
    }

    private class ExchangeAncientTomesTrade
    implements VillagerTrades.ItemListing {
        private ExchangeAncientTomesTrade() {
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource random) {
            if (validEnchants.isEmpty() || !AncientTomesModule.this.isEnabled()) {
                return null;
            }
            Holder<Enchantment> target = validEnchants.get(random.nextInt(validEnchants.size()));
            ItemStack enchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(target, ((Enchantment)target.value()).getMaxLevel()));
            ItemStack outputTome = AncientTomeItem.getEnchantedItemStack(target);
            return new MerchantOffer(new ItemCost((ItemLike)ancient_tome), Optional.of(new ItemCost(enchantedBook.getItemHolder(), 1, DataComponentPredicate.allOf((DataComponentMap)enchantedBook.getComponents()))), outputTome, 3, 3, 0.2f);
        }
    }
}

