/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.violetmoon.quark.content.building.block.CutVineBlock;
import org.violetmoon.zeta.client.AlikeColorHandler;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="building")
public class ShearVinesModule
extends ZetaModule {
    public static Block cut_vine;
    @Hint
    Item vine = Items.VINE;

    @LoadEvent
    public final void register(ZRegister event) {
        cut_vine = new CutVineBlock(this);
    }

    @PlayEvent
    public void onRightClick(ZRightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (this.zeta().itemExtensions.get(stack).canShearZeta(stack)) {
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() == Blocks.VINE) {
                BlockState newState = cut_vine.defaultBlockState();
                Map map = VineBlock.PROPERTY_BY_DIRECTION;
                for (Direction d : map.keySet()) {
                    BooleanProperty prop = (BooleanProperty)map.get(d);
                    newState = (BlockState)newState.setValue((Property)prop, (Comparable)((Boolean)state.getValue((Property)prop)));
                }
                world.setBlockAndUpdate(pos, newState);
                BlockPos testPos = pos.below();
                BlockState testState = world.getBlockState(testPos);
                while (testState.is(Blocks.VINE) || testState.is(cut_vine)) {
                    world.removeBlock(testPos, false);
                    testPos = testPos.below();
                    testState = world.getBlockState(testPos);
                }
                Player player = event.getPlayer();
                world.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.5f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    MiscUtil.damageStack((ItemStack)stack, (int)1, (Player)player, (EquipmentSlot)(event.getHand().equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                }
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
                event.setCanceled(true);
            }
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ShearVinesModule {
        private final AlikeColorHandler LIKE_VINE = new AlikeColorHandler(Blocks.VINE.defaultBlockState());

        @LoadEvent
        public void blockColors(ZAddBlockColorHandlers event) {
            event.registerNamed(this.zeta(), b -> this.LIKE_VINE, new String[]{"vine"});
        }

        @LoadEvent
        public void itemColors(ZAddItemColorHandlers event) {
            event.registerNamed(this.zeta(), i -> this.LIKE_VINE, new String[]{"vine"});
        }
    }
}

